import React from 'react';
import { UploadOutlined } from '@ant-design/icons';
import { message } from 'antd';

interface UploadButtonProps {
    onFileUpload: (file: File) => void;
}

const Upload: React.FC<UploadButtonProps> = ({ onFileUpload }) => {
    const handleFileChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        const file = event.target.files?.[0];
        if (file) {
            const allowedTypes = ['.xlsx', '.sjs', '.ssjson'];
            const fileExtension = file.name.slice(file.name.lastIndexOf('.')).toLowerCase();

            if (allowedTypes.includes(fileExtension)) {
                onFileUpload(file);
            } else {
                message.error('please upload xlsx, sjs or ssjson file type');
            }
        }
    };
    return (
        <div>
            <button
                style={{
                    background: 'transparent',
                    border: 'none',
                    cursor: 'pointer',
                    fontSize: 'inherit',
                    display: 'flex',
                    alignItems: 'center',
                    gap: '8px',
                    color: '#000',
                    transition: 'color 0.3s',
                }}
                onClick={() => document.getElementById('fileInput')?.click()}
                onMouseEnter={(e) => (e.currentTarget.style.color = '#1890ff')}
                onMouseLeave={(e) => (e.currentTarget.style.color = '#000')}
            >
                <UploadOutlined style={{ fontSize: 'inherit' }} />
                Upload
            </button>
            <input
                id="fileInput"
                type="file"
                style={{ display: 'none' }}
                onChange={handleFileChange}
                accept=".xlsx,.sjs,.ssjson"
            />
        </div>
    );
};

export default Upload;
