export function normalizeError (e: unknown) {
    if (typeof e === 'string') {
        return e;
    } else if (e instanceof Error) {
        return e.message;
    } else {
        return 'unknown error!';
    }
}

const uuid_characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
const uuid_character_len = uuid_characters.length;
export function uuid(length = 8) {
    let id = '';
    for (let i = 0; i < length; i++) {
        const randomIndex = ~~(Math.random() * uuid_character_len);
        id += uuid_characters[randomIndex];
    }
    return id;
}

export function translateToLocalDate (date: string) {
    const utcDate = new Date(date);

    const timezoneOffset = new Date().getTimezoneOffset();

    return new Date(utcDate.getTime() - (timezoneOffset * 60000)).toLocaleString();
}