import { IMiddleware } from '@mescius/js-collaboration';
import { IDocSubmitMiddlewareContext } from '@mescius/js-collaboration-ot';
import { DocServices } from '../services/doc.mjs';

export function submitExtraInfo(docServices: DocServices): IMiddleware<IDocSubmitMiddlewareContext<any, any>> {
    return async (context, next) => {
        const { id, op } = context.request;

        let userId;
        if (context.connection) {
            userId = (context.connection.tags.get('user') as { id: string }).id;
        } else {
            userId = (context.request.context.options as { userId: string }).userId;
        }

        await docServices.insertOpEx(id, op.v, userId);
        await docServices.updateLastModifyInfo(id, userId);
    
        await next();
    };
}
