const puppeteer = require('puppeteer');

(async () => {
    const browser = await puppeteer.launch({ headless: false });
    const page = await browser.newPage();

    await page.goto('https://www.grapecity.com/spreadjs/demos/sample/features/workbook/initialization/purejs/');

    let value;

    // executes script in the browser
    try {
        value = await page.evaluate(() => {
            // gets the spread instance
            let spread = GC.Spread.Sheets.findControl(document.querySelector('[gcuielement="gcSpread"]'));

            let sheet = spread.getActiveSheet();
            // returns the value of cell A1 of the worksheet
            return sheet.getValue(0, 0);
        })
        console.log(value);
    } catch (e) {
        console.log('test failed');
    } finally {
        setTimeout(async () => {
            await browser.close();
        }, 3000);
    }
})();