﻿using System.Diagnostics;
using System.Xml;

namespace RichTextBoxExport
{
    internal class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Processing report...");

            var report = new GrapeCity.ActiveReports.SectionReport();
            using var reader = XmlReader.Create("RichContent.rpx");
            report.LoadLayout(reader);
            report.Run();

            var pdfExport = new GrapeCity.ActiveReports.Export.Pdf.Section.PdfExport();
            var exportFileName = "SectionReportExport.pdf";
            pdfExport.Export(report.Document, exportFileName);

            Process.Start(new ProcessStartInfo(exportFileName) { UseShellExecute = true });

            Console.WriteLine("Done!");
        }
    }
}
