import React from "react";
import SpreadJSViewer from "./SpreadJSViewer";
import "./App.css";

export default function App() {
  const [mounted, setMounted] = React.useState(true);
  const [refreshKey, setRefreshKey] = React.useState(0);

  return (
    <div className="app-container">
      <div className="app-toolbar">
        <button onClick={() => setMounted((m) => !m)}>
          {mounted ? "Unmount Designer" : "Mount Designer"}
        </button>

        <button onClick={() => setRefreshKey((k) => k + 1)} disabled={!mounted}>
          Force Re-render
        </button>
      </div>

      <div className="app-content">
        {mounted && <SpreadJSViewer key={refreshKey} />}
      </div>
    </div>
  );
}
