import React from "react";
import "@mescius/spread-sheets-designer-resources-en";
import * as GC from "@mescius/spread-sheets";
import "@mescius/spread-sheets-io";
import "@mescius/spread-sheets-designer";

import "@mescius/spread-sheets/styles/gc.spread.sheets.excel2013lightGray.css";
import "@mescius/spread-sheets-designer/styles/gc.spread.sheets.designer.min.css";

import { Designer } from "@mescius/spread-sheets-designer-react";

// V19
GC.Spread.Sheets.LicenseKey = "<<SPREADJS_V19_LICENSE_KEY>>";
(GC.Spread.Sheets as any).Designer.LicenseKey =
  "<<SPREADJS_DESIGNER_V19_LICENSE_KEY>>";

export default function SpreadJSViewer() {
  const designerRef = React.useRef<any>(null);

  const initDesigner = React.useCallback((designer: any) => {
    designerRef.current = designer;
  }, []);

  return (
    <div style={{ width: "100%", height: "100%" }}>
      <Designer
        styleInfo={{ width: "100%", height: "100%" }}
        designerInitialized={initDesigner}
      />
    </div>
  );
}
