﻿Imports C1.Win.C1FlexGrid
Imports C1.Win.C1FlexGrid.Classic

Public Class Form1
    Dim WithEvents fg As New C1FlexGridClassic
    Dim Max As Double
    Sub New()

        ' This call is required by the designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.

        fg.Dock = DockStyle.Fill
        fg.DrawMode = DrawModeEnum.OwnerDraw
        Me.Controls.Add(fg)

        Dim i As Long
        ' initialize array with random data
        Dim count(1, 7) As Single
        For i = 0 To 7
            count(0, i) = Rnd() * 100
            count(1, i) = Rnd() * 100
        Next
        ' initialize control
        fg.Cols = 3
        fg.Rows = 9
        fg.Cell(CellPropertySettings.flexcpText, 0, 0) = "Age Range"
        fg.Cell(CellPropertySettings.flexcpText, 0, 1) = "Females"
        fg.Cell(CellPropertySettings.flexcpText, 0, 2) = "Males"
        ' make data bold
        fg.Cell(CellPropertySettings.flexcpFontBold, 1, 1, fg.Rows - 1, fg.Cols - 1) = True
        ' place text in cells, keep track of maximum
        For i = 0 To 7
            fg.Cell(CellPropertySettings.flexcpText, i + 1, 0) = 10 * i & " - " & (10 * (i + 1) - 1)
            fg.Cell(CellPropertySettings.flexcpText, i + 1, 1) = count(0, i)
            fg.Cell(CellPropertySettings.flexcpText, i + 1, 2) = count(1, i)
            If count(0, i) > max Then max = count(0, i)
            If count(1, i) > max Then max = count(1, i)
        Next
        ' set each cell's flood percentage,
        ' using max to scale from 0 to -100 for column 1
        ' and from 0 to 100 for column 2:
        'For i = 0 To 7
        '    fg.Cell(CellPropertySettings.flexcpFloodPercent, i + 1, 1) = -100 * (count(0, i) / max)
        '    'fg.Cell(CellPropertySettings.flexcpFloodPercent, i + 1, 1) = -100 * (count(0, i) / max)
        '    fg.Cell(CellPropertySettings.flexcpFloodPercent, i + 1, 2) = 100 * (count(1, i) / max)
        '    fg.Cell(CellPropertySettings.flexcpFloodColor, i + 1, 1) = Color.Red
        '    'fg.Cell(CellPropertySettings.flexcpFloodColor, i + 1, 1) = Color.Yellow
        '    fg.Cell(CellPropertySettings.flexcpFloodColor, i + 1, 2) = Color.Aqua
        'Next

        fg.AutoSizeCols()

    End Sub

    Sub FG_OwnerDraw(sender As Object, e As OwnerDrawCellEventArgs) Handles fg.OwnerDrawCell
        If e.Measuring Then Return
        Dim val As Double
        If Double.TryParse(fg.Cell(CellPropertySettings.flexcpText, e.Row, e.Col), val) Then
            'configuring the bar
            Dim rc = e.Bounds
            Dim originalWidth = rc.Width
            rc.Width *= (val / Max)

            'draw background
            e.DrawCell(DrawCellFlags.Background)
            e.DrawCell(DrawCellFlags.Border)

            'if Flood percent is negative shift the bar to right hand side
            If e.Col = 1 Then
                rc.X += originalWidth - rc.Width
            End If

            rc.Inflate(-1, -1)
            e.Graphics.FillRectangle(IIf(e.Col = 1, Brushes.Red, Brushes.Aqua), rc)

            'draw cell content
            e.DrawCell(DrawCellFlags.Content)
        End If
    End Sub

End Class
