using System.Diagnostics;
using Microsoft.AspNetCore.Mvc;
using MultiSelect_PostBack.Models;

namespace MultiSelect_PostBack.Controllers
{
    public class HomeController : Controller
    {
        private readonly ILogger<HomeController> _logger;

        public HomeController(ILogger<HomeController> logger)
        {
            _logger = logger;
        }

        [HttpGet]
        public IActionResult Index()
        {
            ViewBag.Countries = Enumerable.Range(1, 10).Select(i => $"country-{i}").ToList();
            return View(new MyViewModel());
        }

        [HttpPost]
        public IActionResult Index(MyViewModel model)
        {
            var selectedList = model.SelectedCountries?
                .Split(',', StringSplitOptions.RemoveEmptyEntries)
                .ToList();

            Debug.WriteLine("Selected Countries:");
            foreach (var c in selectedList ?? [])
                Debug.WriteLine(c);

            ViewBag.Countries = Enumerable.Range(1, 10).Select(i => $"country-{i}").ToList();
            return View(model);
        }


        public IActionResult Privacy()
        {
            return View();
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
