﻿Imports C1.Win.CoditionalFormatting
Imports C1.Win.RulesManager

Public Class Form1
    Public Sub New()
        InitializeComponent()

        ' Create DataTable
        Dim dt As New System.Data.DataTable()

        ' Add columns
        dt.Columns.Add("ID", GetType(Integer))
        dt.Columns.Add("Name", GetType(String))
        dt.Columns.Add("Val", GetType(Integer))

        ' Add rows
        dt.Rows.Add(1, "name-1", 0)
        dt.Rows.Add(2, "name-2", 50)
        dt.Rows.Add(3, "", 50)
        dt.Rows.Add(4, Nothing, -100)

        ' Assign DataSource
        C1FlexGrid1.DataSource = dt

        ' Create FooterDescription
        Dim footer As New C1.Win.C1FlexGrid.FooterDescription()
        footer.Caption = "Total"

        ' Add aggregate
        Dim agg As New C1.Win.C1FlexGrid.AggregateDefinition()
        agg.Column = 3
        agg.Aggregate = C1.Win.C1FlexGrid.AggregateEnum.Sum
        footer.Aggregates.Add(agg)

        ' Add footer to grid
        C1FlexGrid1.Footers.Descriptions.Add(footer)

        C1RulesManager1.SetC1RulesManager(C1FlexGrid1, C1RulesManager1)

        AddHandler DirectCast(C1FlexGrid1, IFormattableView).ItemFormatting, AddressOf FlexGrid_ItemFormatting
    End Sub

    Private Sub FlexGrid_ItemFormatting(sender As Object, e As ItemFormattingEventArgs)
        If e.Item = C1FlexGrid1.Rows.Count - 1 Then
            e.Cancel = True
        End If
    End Sub

    Private Sub toolStripButton1_Click(sender As Object, e As EventArgs) Handles ToolStripButton1.Click
        If C1RulesManager1.Rules.Cast(Of Rule)().Where(Function(r) r.Name = "Zero Check").FirstOrDefault() Is Nothing Then
            C1RulesManager1.Rules.Add(New Rule() With {
                .Name = "Zero Check",
                .Expression = "[Val] = 0",
                .Style = New ItemStyle With {.BackColor = Color.IndianRed}
            })
        End If
    End Sub
End Class
