﻿using C1.WPF.Docking;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace DockCloseAllTabs
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        
        private void dockTabControl_Loaded(object sender, RoutedEventArgs e)
        {
            var dockTabControl = sender as C1DockTabControl; 
            if (dockTabControl != null)
            {
                var hiddenButton = dockTabControl.Template.FindName("HiddenButton", dockTabControl) as Button;
                if (hiddenButton != null)
                {
                    hiddenButton.PreviewMouseLeftButtonDown += (s, e) =>
                    {
                        e.Handled = true;
                        var res = MessageBox.Show("Are you sure you want to close windows?", "Confirm Close", MessageBoxButton.YesNo, MessageBoxImage.Question);

                        if (res == MessageBoxResult.Yes)
                        {
                            // closing all floating windows
                            foreach (var window in this.OwnedWindows)
                            {
                                var currentWindow = (WPFWindow)window;
                                if (currentWindow != null)
                                {
                                    currentWindow.Close();
                                }
                            }

                            // closing all docked tabs
                            dockTabControl.Items.Clear();
                        }
                    };
                }                
            }
        }
        
    }
}
