﻿using C1.DataCollection;
using C1.DataCollection.BindingList;
using System.ComponentModel;
using C1.DataCollection.AdoNet;
using System;
using System.Data.SqlClient;
using C1.Win.Ribbon;
using System.Windows.Forms;
using System.Data.Common;
using System.Collections.Generic;

namespace FlexGridVirtualization
{
    public partial class Form1 : C1RibbonForm
    {
        DateTime timestamp;
        public Form1()
        {
            InitializeComponent();
            SetupGrid();
        }

        private void SetupGrid()
        {
            SqlConnection conn = new SqlConnection("Data Source=localhost;Initial Catalog=TestDatabase;Integrated Security=True;Encrypt=False");
            var dataCollection = new C1AdoNetCursorDataCollection<DummyData>(conn, "Dummy_Data", new List<string>() { "ItemCode", "ItemDes", "Status", "Sales", "Buy", "Make", "Stock" }, 100);

            timestamp = DateTime.Now;

            dataCollection.LoadMoreItemsAsync();
            c1FlexGrid1.DataSource = new C1DataCollectionBindingList(dataCollection);

            c1FlexGrid1.AfterDataRefresh += C1FlexGrid1_AfterDataRefresh;
            c1FlexGrid1.AfterScroll += C1FlexGrid1_AfterScroll;
        }

        private void C1FlexGrid1_AfterDataRefresh(object sender, ListChangedEventArgs e)
        {
            MessageBox.Show($"Time taken: {(DateTime.Now - timestamp).TotalMilliseconds}");
            c1FlexGrid1.AfterDataRefresh -= C1FlexGrid1_AfterDataRefresh;
        }

        private void C1FlexGrid1_AfterScroll(object sender, C1.Win.C1FlexGrid.RangeEventArgs e)
        {
            if (e.NewRange.BottomRow == c1FlexGrid1.Rows.Count - 1)
            {
                var list = c1FlexGrid1.DataSource as C1DataCollectionBindingList;
                list.DataCollection.LoadMoreItemsAsync();
            }
        }
    }

    class DummyData
    {
        public string ItemCode { get; set; }
        public string ItemDes { get; set; }
        public string Status { get; set; }
        public string Sales { get; set; }
        public string Buy { get; set; }
        public string Make { get; set; }
        public string Stock { get; set; }
    }
}
