﻿using C1.Win.Themes;
using C1.Win.Ribbon;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace RibbonThemesTest
{
  public partial class FormMain : C1RibbonForm
  {

    private FormChild otherForm;

    public FormMain()
    {
      InitializeComponent();

      //Fill themes combo:
      foreach (string theme in C1ThemeController.GetThemes())
      {
        this.comboBoxTheme.Items.Add(theme);
      }
      this.comboBoxTheme.SelectedIndex = 0;
    }

    protected override void OnLoad(EventArgs e)
    {
      base.OnLoad(e);


      //Create the other form:
      otherForm = new FormChild();
      otherForm.Text = "Child form";
      otherForm.Location = new Point(this.Location.X + 400, this.Location.Y + 200);
      
      otherForm.Show();

      //Theme is automatically applied to current form, as the combo "SelectedIndexChanged" event is raised on initialization. But 
      //the child form is not created.
      this.comboBoxTheme_SelectedIndexChanged(null, null);
    }

    
    private void comboBoxTheme_SelectedIndexChanged(object sender, EventArgs e)
    {
      string themeName = (string)this.comboBoxTheme.SelectedItem;

      C1Theme theme = C1ThemeController.GetThemeByName(themeName, true);
      //Clone it, as they are cached. Selecting the theme multiple times would break it.
      theme = (C1Theme)theme.Clone();

      //Used when there is C1Ribbon control on the Form, and the form being used is C1RibbonForm
      //in this scenario, the QAT panel of the C1Ribbon control is merged with the TitleBar of the C1RibbonForm
      BackgroundProp themeItemInactive = (BackgroundProp)theme.Children.GetItemByPath("C1Ribbon365\\Form\\Qat\\Inactive\\Background");

      //Get also the "default" color:
      BackgroundProp themeItemActive = (BackgroundProp)theme.Children.GetItemByPath("C1Ribbon365\\Form\\Qat\\Default\\Background");

      Color colorNew;
      Color colorCurrent;
      //"Office356..:" themes don't have the "Inactive" theme:
      if (themeItemInactive.HasValue == false)
      {
        //Get it from the "Default" theme item:
        BackgroundProp themeItemRef = (BackgroundProp)themeItemInactive.Ref;
        string parentHierarchy = themeItemInactive.FullName + Environment.NewLine +
          themeItemRef.FullName + Environment.NewLine;
       
        while (themeItemRef.HasValue == false)
        {
          themeItemRef = (BackgroundProp) themeItemRef.Ref;

          if (themeItemRef == null)
          {
            MessageBox.Show(this, "Could not get back color, no theme item in hierarchy has background:" + Environment.NewLine + parentHierarchy);
            return;
          }
          else
          {
            parentHierarchy += themeItemRef.FullName + Environment.NewLine;
          }
        }

        colorCurrent = themeItemActive.Value.GetSolidColor().Value;
      }
      else
      {
        colorCurrent = themeItemInactive.Value.GetSolidColor().Value;
      }

      //Now decide whether it is a bright or  dark theme.
      float brightness = colorCurrent.GetBrightness();
      //"MacSilver" is the only theme with a brightness of "1", all others have lower values.
      if (brightness < 0.9)
      {
        //dark theme: make the inactive ribbon header brighther:

        //With "Material" the value "0.8" looks good. With "MaterialDark" the brightness difference appears to be bigger.
        //According to code a value beetween 0 (results in SystemColors.ControlLight) and 1 (SystemColors.ControlLightLight),
        //which means the resulting color is based on those two values:
        //colorNew = ControlPaint.Light(colorCurrent, 0.8f);
        colorNew = ControlPaint.Light(colorCurrent, 0.5f);


        /*Experimental: use native functions to convert RDP to HSL, modify Luminance and convert back. 
        int hue = 0, sat = 0, light = 0;
        ColorRGBToHLS(colorCurrent.ToArgb(), ref hue, ref light, ref sat);
        //Increase by 20% percent. If Value is below 20 (e.g. "0" = black), then use fixed increment of 20.
        if (light < 20)
        {
          light = 20;
        }
        else
        {
          light = (int)(light * 1.2);
        }

        int x = ColorHLSToRGB(hue, light, sat);
        colorNew = Color.FromArgb(x);
        //Restore original "alpha" (not contained in previous conversions)
        colorNew = Color.FromArgb(colorCurrent.A, colorNew);
        */

        //If the theme has a reference to another theme, reset it.
        themeItemInactive.Ref = null;
        themeItemInactive.Value = new ThemeSolidBackground(colorNew);
      }
      else
      {
        //If the theme is a bright theme, make  the active form darker and the inactive form brighter.
        
        //Switch "inactive" to the (bright) "default" color:
        themeItemInactive.Ref = null;
        themeItemInactive.Value = new ThemeSolidBackground(colorCurrent);

        //Make the active form darker.
        //
        //Um 20% dunkler machen!
        //According to code a value beetween 0 (results in SystemColors.ControlDark) and 1 (SystemColors.ControlDarkDark):
        //colorNew = ControlPaint.Dark(colorCurrent, 0.8f);
        colorNew = ControlPaint.Dark(colorCurrent, 0.5f);


        themeItemActive.Ref = null;
        themeItemActive.Value = new ThemeSolidBackground(colorNew);
      }



      C1ThemeController.ApplyThemeToControlTree(this, theme);
      C1ThemeController.ApplyThemeToControlTree(this.otherForm, theme);
    }

    /*Experimental code: native api calls#
    
    [DllImport("shlwapi.dll")]
    //public static extern uint ColorHLSToRGB(uint H, uint L, uint S);  //"DWORD", the return value "COLORREF" is also DWORD
    public static extern int ColorHLSToRGB(int H, int L, int S);

    
    //See https://www.pinvoke.net/default.aspx/shlwapi.colorrgbtohls

    [DllImport("shlwapi.dll")]
    public static extern void ColorRGBToHLS(
        int clrRGB, //uint clrRGB,
        //ref ushort pwHue,
        //ref ushort pwLuminance,
        //ref ushort pwSaturation
        ref int pwHue,
        ref int pwLuminance,
        ref int pwSaturation
      );
    */

  }


}