﻿Imports C1.Chart.Printing
Imports C1.Win.Chart
Imports System
Imports System.Collections.Generic
Imports System.Data
Imports System.Drawing
Imports System.Drawing.Printing
Imports System.Windows.Forms

Namespace AxisXNameInsteadOfNumber
    Public Partial Class Form1
        Inherits Form
        Private dt As DataTable

        Public Sub New()
            InitializeComponent()
            CreateTable()
        End Sub

        Private Sub Form1_Load(ByVal sender As Object, ByVal e As EventArgs)
            FlexChart1.DataSource = dt
            FlexChart1.BeginUpdate()
            FlexChart1.ChartType = C1.Chart.ChartType.Column
            FlexChart1.Series.Clear()
            FlexChart1.Series.Add(New Series With {
                .Name = "Stunden",
                .Binding = "Hours_per_cost_center",
                .BindingX = "Hours"
            })
            FlexChart1.Series.Add(New Series With {
                .Name = "Ser2",
                .Binding = "New_Series",
                .BindingX = "Hours"
            })

            ' AxisX
            FlexChart1.AxisX.DataSource = ConvertDataTableToList(dt)
            FlexChart1.AxisX.Binding = "Ob_Hours,Ob_Code"

            FlexChart1.AxisX.Labels = True
            FlexChart1.AxisX.LabelAngle = -40

            ' Daten für die AxisX Säule
            FlexChart1.DataLabel.Content = "{STStunden}"
            FlexChart1.DataLabel.Position = C1.Chart.LabelPosition.Top

            ' AxisY
            FlexChart1.AxisY.MajorUnit = 50
            FlexChart1.AxisY.Min = 0
            FlexChart1.AxisY.Max = 900

            ' Specify titles for FlexChart header and axes
            FlexChart1.Header.Content = "Stunden pro Kostenstellen"
            FlexChart1.EndUpdate()
        End Sub


        Public Sub CreateTable()
            dt = New DataTable()
            dt.Columns.Add("Hours", GetType(Integer))
            dt.Columns.Add("Hours_per_cost_center", GetType(Double))
            dt.Columns.Add("New_Series", GetType(Double))
            dt.Columns.Add("TACodeKST", GetType(Integer))

            Dim random As Random = New Random()
            Dim start = 2001
            For hours = 0 To 30
                Dim hoursPerCostCenter As Double = random.NextDouble() * 900
                Dim newData As Double = random.NextDouble() * 450
                dt.Rows.Add(hours, hoursPerCostCenter, newData, Math.Min(Threading.Interlocked.Increment(start), start - 1))
            Next
        End Sub

        Public Function ConvertDataTableToList(ByVal dataTable As DataTable) As List(Of MyObject)
            Dim myList As List(Of MyObject) = New List(Of MyObject)()

            For Each row As DataRow In dataTable.Rows
                Dim obj As MyObject = New MyObject()

                ' Assuming the column names in the DataTable match the property names in the MyObject class
                obj.Ob_Hours = Convert.ToInt32(row("Hours"))
                obj.Ob_HPCC = Convert.ToDouble(row("Hours_per_cost_center"))
                obj.Ob_New = Convert.ToDouble(row("New_Series"))
                obj.Ob_Code = row("TACodeKST").ToString() ' string type property need to be bound as custom label to the axis

                myList.Add(obj)
            Next

            Return myList
        End Function

        Private Sub exportBtn_Click(ByVal sender As Object, ByVal e As EventArgs)
            'create Printer FlexChart
            Dim chartPrinter As ChartPrinter = New ChartPrinter(FlexChart1, True)

            Dim PageSettngs As PageSettings = New PageSettings() With {
                .Landscape = True
            }

            'replace default page settings with custom page settings
            chartPrinter.PageSettingsProp = PageSettngs


            'replace default printer settings with custom printer settings, if any
            'if (PrinterSettngs != null)
            '{
            '    chartPrinter.PrintSettingsProp = PrinterSettngs;
            '}

            'set whether or not to resize FlexChart according to the print rectangle
            Dim pscale As ChartPrinter.PrintScale = [Enum].Parse(GetType(ChartPrinter.PrintScale), "None")

            'set whether to print in GrayScale or not
            chartPrinter.UseGrayScale = False

            Dim usePrintPreview = True
            Dim printAsBitmap = True

            'chartPrinter.PrintCtrl()
            'print FlexChart with specific printer and page settings
            chartPrinter.PrintCtrl(pscale, New Rectangle(50, 50, 400, 400), PageSettngs, printAsBitmap, usePrintPreview)
        End Sub
    End Class

    Public Class MyObject
        Public Property Ob_Hours As Integer

        Public Property Ob_HPCC As Double

        Public Property Ob_New As Double

        Public Property Ob_Code As String
    End Class

    Public Class DataPointAxisX
        Public Property Value As Integer

        Public Property Code As String
    End Class
End Namespace
