﻿using C1.Win.Chart;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static C1.Util.Win.Win32;

namespace AxisXNameInsteadOfNumber
{
    public partial class Form1 : Form
    {
        private DataTable dt;

        public Form1()
        {
            InitializeComponent();
            CreateTable();
            
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            FlexChart1.DataSource = dt;
            FlexChart1.BeginUpdate();
            FlexChart1.ChartType = C1.Chart.ChartType.Column;
            FlexChart1.Series.Clear();
            FlexChart1.Series.Add(new Series { Name = "Stunden", Binding = "Hours_per_cost_center", BindingX = "Hours" });

            // AxisX
            //FlexChart1.AxisX.Labels.Equals("{TACodeKST}");
            FlexChart1.AxisX.DataSource = GetAxisXSource();
            FlexChart1.AxisX.Binding = "Value,Code";
            FlexChart1.AxisX.Labels = true;
            FlexChart1.AxisX.LabelAngle = -40;

            // Daten für die AxisX Säule
            FlexChart1.DataLabel.Content = "{STStunden}";
            FlexChart1.DataLabel.Position = C1.Chart.LabelPosition.Top;

            // AxisY
            FlexChart1.AxisY.MajorUnit = 50;
            FlexChart1.AxisY.Min = 0;
            FlexChart1.AxisY.Max = 900;

            // Specify titles for FlexChart header and axes
            FlexChart1.Header.Content = "Stunden pro Kostenstellen";
            FlexChart1.EndUpdate();
        }

        public List<DataPointAxisX> GetAxisXSource()
        {
            List<DataPointAxisX> dtPoints = new List<DataPointAxisX>();
            string[] codes = { "A", "B", "C", "D", "E", "F", "G" }; 
            for (int i = 0, c=0; i<=30; i=i+5, c++)
            {
                DataPointAxisX dp = new DataPointAxisX() { Value = i, Code = codes[c] };
                dtPoints.Add(dp);
            }
            return dtPoints;
        }

        public void CreateTable()
        {
            dt = new DataTable();
            dt.Columns.Add("Hours", typeof(int));
            dt.Columns.Add("Hours_per_cost_center", typeof(double));

            Random random = new Random();

            for (int hours = 0; hours <= 30; hours++)
            {
                double hoursPerCostCenter = random.NextDouble() * 900;
                dt.Rows.Add(hours, hoursPerCostCenter);
            }
        }
    }

    public class DataPointAxisX
    {
        public int Value { get; set; }

        public string Code { get; set; }
    }
}
