﻿import * as React from 'react';
import { SpreadSheets, Worksheet } from '@grapecity/spread-sheets-react';
import * as GC from '@grapecity/spread-sheets';

import './styles.css';

let spread; 

export function AppFunc() {
    let initSpread = function (value) {
        spread = value;

        let sheet = spread.getActiveSheet();
        sheet.setFormula(1, 1, '=SUM(1, 2, 3)');

        spread.bind(GC.Spread.Sheets.Events.ClipboardPasted, (event, args) => {
            let row = args.cellRange.row;
            let col = args.cellRange.col;
            let sheet = args.sheet;
            let formula = sheet.getFormula(row, col);
            let activeRow = sheet.getActiveRowIndex();
            let activeCol = sheet.getActiveColumnIndex();
            if (formula) {
                spread.suspendEvent();
                sheet.setFormula(activeRow, activeCol, formula);
                spread.resumeEvent();
            }
        });

    };

    return (
        <div class="sample-tutorial">
            <div id="ss" class="sample-spreadsheets">
                <SpreadSheets workbookInitialized={(spread) => initSpread(spread)}></SpreadSheets>
            </div>
            <div class="options-container" id="options">
                <span>Copy cell B2 and paste on any other cell</span>
            </div>
        </div >
    );
}