﻿window.process = {
    env: {
        NODE_ENV: "production"
    }
};

(function (global) {
    System.config({
        transpiler: 'systemjs-plugin-babel',
        babelOptions: {
            es2015: true,
            react: true
        },
        meta: {
            '*.css': { loader: 'systemjs-plugin-css' }
        },
        paths: {
            // paths serve as alias
            '*': './node_modules/*',
        },
        packageConfigPaths: ['./node_modules/*/package.json', "./node_modules/@grapecity/*/package.json"],
        // packages tells the System loader how to load when no filename and/or no extension
        packages: {
            "./src": {
                defaultExtension: 'jsx'
            },
            "object-assign": {
                main: "index.js"
            },
            "node_modules": {
                defaultExtension: 'js'
            },
        }
    });
})(this);
