﻿/*REPLACE_MARKER*/
/*DO NOT DELETE THESE COMMENTS*/
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import GC from '@mescius/spread-sheets';
import "@mescius/spread-sheets-tablesheet";
import { SpreadSheets, Worksheet } from '@mescius/spread-sheets-react';
import './styles.css';

const Component = React.Component;

function _getElementById(id) {
    return document.getElementById(id);
}

export class App extends Component {
    constructor(props) {
        super(props);
    }
    render() {
        return (
            <div class="sample-tutorial">
                <div class="sample-spreadsheets">
                    <SpreadSheets workbookInitialized={spread => this.initSpread(spread)}>
                    </SpreadSheets>
                </div>
            </div>
        );
    }
    initSpread(spread) {
        spread.suspendPaint();
        spread.clearSheets();
        spread.options.autoFitType = GC.Spread.Sheets.AutoFitType.cellWithHeader;

        //init a data manager
        var tableName = "Supplier";
        var baseApiUrl = getBaseApiUrl();
        var apiUrl = baseApiUrl + "/" + tableName;
        var dataManager = spread.dataManager();
        var myTable = dataManager.addTable("myTable", {
            remote: {
                read: {
                    url: apiUrl
                }
            }
        });

        //init a table sheet
        var sheet = spread.addSheetTab(0, "TableSheet1", GC.Spread.Sheets.SheetType.tableSheet);
        sheet.options.allowAddNew = false; //hide new row

        //bind a view to the table sheet
        myTable.fetch().then(function () {
            var style = { formatter: 'MM/dd/yyyy' };
            var view = myTable.addView("myView", [
                { value: "Id", width: 80 },
                { value: "CompanyName", width: 200, caption :"Company Name" },
                { value: "ContactName", width: 150, caption :"Contact" },
                { value: "ContactTitle", width: 200, caption :"Title" },
                { value: "Address", width: 200 },
                { value: "City", width: 150, caption :"City" },
                { value: "State", width: 100, caption :"State" },
                { value: "Region", width: 100, caption :"Region" }
            ]);
            sheet.setDataView(view);
        });

        spread.resumePaint();
    }
}

function getBaseApiUrl() {
    return 'https://developer.mescius.com/spreadjs/demos/features/table-sheet/overview/react'.match(/http.+spreadjs\/demos\//)[0] + 'server/api';
}