﻿import * as React from 'react';
import GC from '@mescius/spread-sheets';
import "@mescius/spread-sheets-tablesheet";
import { SpreadSheets } from '@mescius/spread-sheets-react';
import './styles.css';

export function AppFunc() {
    const [spread, setSpread] = React.useState()
    const [sheet, setSheet] = React.useState()
    const [table, setTable] = React.useState()

    // init SpreadJS
    const initSpread = (spread) => {
        setSpread(spread);
        loadData(spread);
    };

    // load init data
    const loadData = async (spread) => {
        spread.suspendPaint();
        spread.clearSheets();
        spread.options.autoFitType = GC.Spread.Sheets.AutoFitType.cellWithHeader;

        const tableName = "Supplier";
        const apiUrl = getBaseApiUrl() + "/" + tableName;
        const dataManager = spread.dataManager();
        const myTable = dataManager.addTable("myTable", {
            remote: { read: { url: apiUrl } }
        });

        const sheet = spread.addSheetTab(0, "TableSheet1", GC.Spread.Sheets.SheetType.tableSheet);
        sheet.options.allowAddNew = false;

        await myTable.fetch().then(() => {
            const view = myTable.addView("myView", [
                { value: "Id", width: 80 },
                { value: "CompanyName", width: 200, caption: ["Company Name 1", "Company Name 2"], headerStyle: { foreColor: 'red' } },
                { value: "ContactName", width: 150, caption: "Contact" },
                { value: "ContactTitle", width: 200, caption: "Title" },
                { value: "Address", width: 200 },
                { value: "City", width: 150, caption: "City" },
                { value: "State", width: 100, caption: "State" },
                { value: "Region", width: 100, caption: "Region" }
            ]);
            sheet.setDataView(view);
            spread.resumePaint();
        });

        // adding the applistener here
        spread.commandManager().addListener('appListener', (args) => {
            if (args.command.cmd === "filterTextSelectAction" || args.command.cmd === "filterByCondition") {
                console.log("TableSheet filtered!");
            }
        });

        setTable(myTable);
        setSheet(sheet);
    };

    const handleClearFilter = () => {
        if (!sheet) return;
        const rowFilter = sheet.getSheet().rowFilter();
        if (rowFilter) {
            rowFilter.reset();
        }
    };

    return (
        <div className="sample-tutorial">
            <button onClick={handleClearFilter}>
                Clear filter
            </button>
            <div className="sample-spreadsheets">
                <SpreadSheets workbookInitialized={initSpread} />
            </div>
        </div>
    );
}

function getBaseApiUrl() {
    return 'https://developer.mescius.com/spreadjs/demos/features/table-sheet/overview/react'
        .match(/http.+spreadjs\/demos\//)[0] + 'server/api';
}
