window.onload = function () {
	// host the workbook control in a DIV element with id "ss"
	var spread = new GC.Spread.Sheets.Workbook(document.getElementById('ss'), {
		sheetCount: 1
	});

	/*
	* retrieve the spread workbook object from the host element using findControl static method.
	* var spread = GC.Spread.Sheets.findControl(document.getElementById('ss'));
	*/
	initSpread(spread);
};

function initSpread(spread) {

	var sheet = spread.getSheet(0);
	sheet.name("Sunburst Chart");

	// Sample hierarchical data
	var data = [
		["Region", "Category", "Value"],
		["Asia", "Japan", 120],
		["Asia", "India", 80],
		["Europe", "Germany", 150],
		["Europe", "France", 100],
		["America", "USA", 200],
		["America", "Canada", 90],
	];

	sheet.setArray(0, 0, data);
	sheet.setColumnWidth(0, 100);
	sheet.setColumnWidth(1, 100);
	sheet.setColumnWidth(2, 80);

	// Create Sunburst chart
	var chart = sheet.charts.add(
		"sunburstChart",
		GC.Spread.Sheets.Charts.ChartType.sunburst,
		300, 80, 400, 300,
		"A1:C7"
	);

	// Configure data labels
	var dataLabels = chart.dataLabels();
	dataLabels.showValue = true;           // Show numeric values
	dataLabels.showCategoryName = true;    // Show category names
	dataLabels.showSeriesName = false;
	dataLabels.color = "#000000";

	chart.dataLabels(dataLabels);

	// Toggle labels on button click
	document.getElementById("toggleLabels").onclick = function () {
		var labels = chart.dataLabels();
		labels.showValue = !labels.showValue;
		labels.showCategoryName = !labels.showCategoryName;
		chart.dataLabels(labels);
	};
}
