﻿using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Drawing;

namespace DemoReport1
{
    public class Student
    {
        [Key, Column(Order = 1), MinLength(5), MaxLength(5)]
        public string ID { get; set; }

        [Required, MinLength(10), MaxLength(10), Column(Order = 2)]
        public string Miti { get; set; }

        [Required, DataType(DataType.Date), Column(TypeName = "date", Order = 3)]
        public DateTime Dated { get; set; }

        [Required, MinLength(7), MaxLength(7), Column(Order = 4)]
        public string Mth { get; set; }


        [Required, MinLength(50), MaxLength(50), Column(Order = 6)]
        public string ClassName { get; set; }

        [Required, MaxLength(200), Column(Order = 10)]
        public string StudentName { get; set; }

        public Image Photo { get; set; }

        [Key, Column(Order = 11)]
        public int SN { get; set; }

        [Required, MinLength(50), MaxLength(50), Column(Order = 13)]
        public string FeeName { get; set; }

        [Column(Order = 14)]
        public double Amt { get; set; }

        [Column(Order = 15)]
        public double Discount { get; set; }

        [Required, Column(Order = 16)]
        public double Net { get; set; }

        [Column(Order = 17)] 
        public double OldBalance { get; set; }

        [Column(Order = 18)]
        public double TotalDueAmt { get; set; }


    }

}
