﻿using C1.WPF.Pdf;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace PdfDemo
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        string data = "English : Text example\nJapanese : テキストの例";
        public MainWindow()
        {
            InitializeComponent();            
        }

        private void Create_Pdf(object sender, RoutedEventArgs e)
        {
            C1PdfDocument pdf = new C1PdfDocument();
            
            Font font = new Font("MS Gothic", 9, PdfFontStyle.Regular);

            pdf.PaperKind =PaperKind.A4;
            Rect rect = pdf.PageRectangle;
            rect.Inflate(-48, -48);

            pdf.Security.AllowCopyContent = false;
            pdf.Security.AllowEditContent = false;
            pdf.Security.AllowEditAnnotations = false;
            pdf.FontType = PdfFontType.Embedded;

            while (true)
            {
                int nextChar = pdf.DrawString(data, font, Brushes.Black.Color, rect);
                if (nextChar >= data.Length)
                {
                    break;
                }
                data = data.Substring(nextChar);
                pdf.NewPage();
            }
            pdf.Save(@"D:/NewFile.pdf");
            Process.Start(@"D:/NewFile.Pdf");
        }
    }
}
