﻿using System;
using System.Windows.Forms;
using C1.Win.C1FlexGrid;
using System.Collections;
using System.Drawing;
using System.Collections.Generic;

namespace WindowsFormsApp1
{
    public partial class ButtonColumnDemo : Form
    {
        private ArrayList buttons;
        private List<Column> btnColumns;
        private C1FlexGrid fG;
        public ButtonColumnDemo()
        {
            InitializeComponent();
            Load += Form1_Load;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            fG = new C1FlexGrid();

            fG.Dock = DockStyle.Fill;
            fG.AllowAddNew = true;
            fG.Paint += FG_Paint;
            fG.AfterAddRow += FG_AfterAddRow;
            fG.Rows.Count = 10;
            fG.Cols.Count = 5;
            Controls.Add(fG);

            //initiate button and column list
            buttons = new ArrayList();
            btnColumns = new List<Column>();

            btnColumns.Add(fG.Cols[2]);
            fG[0,1] = "Check";
            fG[0,2] = "Click";
            fG.Cols[1].DataType = typeof(bool);

            //setup buttons on specific column on all of its rows
            foreach (Column col in btnColumns) {
                if (col.Index < fG.Cols.Fixed)
                    { continue; }
                for(int i = 0;i<fG.Rows.Count-1;i++)
                {
                    if (i < fG.Rows.Fixed)
                    { continue; }
                    SetupButtons(fG, col.Index, i);
                }
            }
        }

        private void FG_AfterAddRow(object sender, RowColEventArgs e)
        {
            foreach (Column col in btnColumns)
            {
                SetupButtons(sender as C1FlexGrid, col.Index, e.Row);
            }
        }

        /// <summary>
        /// Creates Button to add onto a cell of flexGrid
        /// </summary>
        /// <param name="sender">flexGrid</param>
        /// <param name="col">col</param>
        /// <param name="row">row</param>
        private void SetupButtons(C1FlexGrid sender,int col,int row) {
            
            var bt = new ColumnButton(sender as C1FlexGrid, row, col);
            buttons.Add(bt);
            bt.Click += Bt_Click;
            bt.Text = "Click";
        }

        private void Bt_Click(object sender, EventArgs e)
        {
            Button btn = (Button)sender;
            MessageBox.Show(((Point)btn.Tag).X.ToString()+" "+ ((Point)btn.Tag).Y.ToString());
        }

        private void FG_Paint(object sender, PaintEventArgs e)
        {
            foreach (ColumnButton bt in buttons) {
                bt.UpdateButtonBounds();
            }
        }


    }

    public class ColumnButton : Button {
        internal C1FlexGrid Grid { get; private set; }
        internal Row Row { get; private set; }
        internal Column Col { get; private set; }

        public ColumnButton(C1FlexGrid flex,int row, int col) {
            Grid = flex;
            Row = Grid.Rows[row];
            Col = Grid.Cols[col];
            Grid.Controls.Add(this);
            Tag = new Point(row, col);
            Paint += ColumnButton_Paint;
        }


        //paints the border of the button
        private void ColumnButton_Paint(object sender, PaintEventArgs e)
        {
            ControlPaint.DrawBorder(e.Graphics, ((Button)sender).ClientRectangle,
                                Color.Green, 1, ButtonBorderStyle.Solid,
                                Color.Green, 1, ButtonBorderStyle.Solid,
                                Color.Green, 1, ButtonBorderStyle.Solid,
                                Color.Green, 1, ButtonBorderStyle.Solid
                                );
        }


        /// <summary>
        /// places the button into the position of the cell
        /// </summary>
        internal void UpdateButtonBounds() {
            int r = Row.Index;
            int c = Col.Index;
            if (r < 0 || c < 0)
            {
                return ;
            }

            Rectangle rc = Grid.GetCellRect(r, c, false);
            this.Bounds = rc;

        }
    }
}
