﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using C1.Win.C1FlexGrid;

namespace CopyGrid_FG
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            c1FlexGrid1.BeginUpdate();

            c1FlexGrid1.DataSource = GetDataTable("Orders");

            /*applying sample styles on the Grid*/

            c1FlexGrid1.Styles.Add("LightCyanBG").BackColor = Color.LightCyan;
            c1FlexGrid1.Styles.Add("BlueText").ForeColor = Color.Blue;

            for (int i = 1; i < c1FlexGrid1.Cols.Count; i += 2)
            {
                c1FlexGrid1.Cols[i].Style = c1FlexGrid1.Styles["LightCyanBG"];
            }

            for (int i = 1; i < c1FlexGrid1.Rows.Count; i += 2)
            {
                c1FlexGrid1.Rows[i].Style = c1FlexGrid1.Styles["BlueText"];
            }

            c1FlexGrid1.EndUpdate();
        }

        /// <summary>
        /// Copy Grid using Excel export
        /// </summary>
        private void copyGridToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (MemoryStream ms = new MemoryStream())
            {
                c1FlexGrid2.BeginUpdate();
                c1FlexGrid1.SaveExcel(ms, "sheet1", FileFlags.OpenXml | FileFlags.IncludeFixedCells);
                c1FlexGrid2.LoadExcel(ms, "sheet1", FileFlags.OpenXml | FileFlags.IncludeFixedCells);
                ms.Close();
                c1FlexGrid2.EndUpdate();
            }
        }

        /// <summary>
        /// Copy Grid manually
        /// </summary>
        private void copyGridUsingWriteXmlToolStripMenuItem_Click(object sender, EventArgs e)
        {
            c1FlexGrid2.BeginUpdate();

            //copy data using temporary xml file
            c1FlexGrid1.WriteXml("temp.xml");
            c1FlexGrid2.ReadXml("temp.xml");
            File.Delete("temp.xml");

            //copy the styles
            c1FlexGrid2.Styles.Clear();
            c1FlexGrid1.Styles.OfType<CellStyle>().ToList().ForEach(s => c1FlexGrid2.Styles.Add(s.Name, s));

            //copy row styles
            foreach (Row row in c1FlexGrid1.Rows)
            {
                if(row.Style != null)
                {
                    c1FlexGrid2.Rows[row.Index].Style = row.Style;
                }
            }

            //copy column styles
            foreach (Column col in c1FlexGrid1.Cols)
            {
                if (col.Style != null)
                {
                    c1FlexGrid2.Cols[col.Index].Style = col.Style;
                }
            }

            c1FlexGrid2.EndUpdate();
        }

        /// <summary>
        /// Sample DataSource for the Grid
        /// </summary>
        #region DataSource

        DataTable GetDataTable(string tableName)
        {
            // set up connection string
            var conn = GetConnectionString();

            // set up SQL statement
            var rs = $"Select * from [{tableName}]";

            // retrieve data into DataSet
            var da = new OleDbDataAdapter(rs, conn);
            var ds = new DataSet();
            da.Fill(ds);

            // return data table
            return ds.Tables[0];
        }
        static string GetConnectionString()
        {
            var path = Environment.GetFolderPath(Environment.SpecialFolder.Personal) + @"\ComponentOne Samples\Common";
            var conn = @"provider=microsoft.jet.oledb.4.0;data source={0}\c1nwind.mdb;";
            return string.Format(conn, path);
        }

        #endregion
    }
}
