import { Component } from '@angular/core';
import '@grapecity/spread-sheets-languagepackages';
import * as GC from "@grapecity/spread-sheets"
import './spread.vertical.text'
import { VerticalCellType } from './spread.vertical.text';
let NS =GC.Spread.Sheets;
@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})

export class AppComponent {
  title = 'spread-intro';
  spreadBackColor="";
  hostStyle = {
    width: '800px',
    height: '600px'
  };
  
  
  toolTip:HTMLDivElement;
  ngAfterViewInit(){
    this.createToolTip("<span>Hi</span>")
  }
  createToolTip(content:string){
    this.toolTip= document.createElement("Div") as HTMLDivElement;
    this.toolTip.innerHTML=content;
    this.toolTip.classList.add("sp-tooltip");
    document.body.appendChild(this.toolTip);
  }
  workbookInit(args){
    let spread:GC.Spread.Sheets.Workbook = args.spread;
    let sheet = spread.getActiveSheet();
    sheet.suspendPaint();
    this.setVerticalText(sheet,1,1,'Left-Top',true,NS.HorizontalAlign.left,NS.VerticalAlign.top);
    spread.getHost().addEventListener("mousemove",(e)=>{
      let y= e.pageY;
      let x= e.pageX;
      var result = spread.hitTest(x,y);
      this.toolTip.style.top = (e.pageY-this.toolTip.offsetHeight-10)+"px";
      this.toolTip.style.left = e.pageX+"px";
      var str= this.getHitAreaName(result);
      if(result && str.length>0){
        this.toolTip.style.display='block';
        this.toolTip.innerHTML=`<b>${str}`;
      }else{
        this.toolTip.style.display='none';
      }
    });
    spread.getHost().addEventListener("mouseout",(e)=>{
      this.toolTip.style.display='none';
    })
    sheet.resumePaint();
  }

  getHitAreaName(result:GC.Spread.Sheets.IWorkbookHitTestInformation){
    if(result) {
        var str = "";
        var worksheetHitInfo = result.worksheetHitInfo;
        var tabStripHitInfo = result.tabStripHitInfo;
        if (worksheetHitInfo) {
            var hitTestType = worksheetHitInfo.hitTestType;
            if (hitTestType === 0) {
                str = 'corner';
            } else if (hitTestType === 1) {
                str = 'colHeader';
            } else if (hitTestType === 2) {
                str = 'rowHeader';
            } else {
                var row = worksheetHitInfo.row;
                var col = worksheetHitInfo.col;
                str = 'viewport; ' + '(row: ' + row + ', col: ' + col + ')';
            }
        } else if (tabStripHitInfo) {
            if (tabStripHitInfo.navButton) {
                str = tabStripHitInfo.navButton;
            } else if (tabStripHitInfo.sheetTab) {
                str = tabStripHitInfo.sheetTab.sheetName;
            } else if (tabStripHitInfo.resize === true) {
                str = "resize";
            } else {
                str = "blank";
            }
        } else if (result.horizontalScrollBarHitInfo) {
            str = result.horizontalScrollBarHitInfo.element;
        } else if (result.verticalScrollBarHitInfo) {
            str = result.verticalScrollBarHitInfo.element;
        } else if (result.footerCornerHitInfo) {
            str = result.footerCornerHitInfo.element;
        }
    }
    return str;
}
  setVerticalText(sheet:GC.Spread.Sheets.Worksheet,row:number, col:number,text:string,autoHeight?:boolean,hAlign?:GC.Spread.Sheets.HorizontalAlign,vAlign?:GC.Spread.Sheets.VerticalAlign){
    let vertical = new VerticalCellType();
    sheet.getRange(row,col).hAlign(hAlign);
    sheet.getRange(row,col).vAlign(vAlign);
    sheet.setCellType(row,col,vertical);
    sheet.setValue(row,col,text);
    if(autoHeight){
      sheet.autoFitRow(row);
    }
  }
}
