import {Spread} from "@grapecity/spread-sheets";
const ns =Spread.Sheets;
export class VerticalCellType extends ns.CellTypes.Text {
    public size =10;
    paint(ctx, value, x, y, w, h, style, context){
        ctx.save();
        ctx.rect(x, y, w, h);
        ctx.clip();
        var tw = this.getAutoFitWidth(value, value.toString(), style, 1, context);
        var th = this.getAutoFitHeight(value, value.toString(), style, 1, context);
        if (style.hAlign === ns.HorizontalAlign.general) {
          style.hAlign = ns.HorizontalAlign.left;
          var type = typeof(value);
          if (type === "boolean") {
            style.hAlign = ns.HorizontalAlign.center;
          } else if (type === "number") {
            style.hAlign = ns.HorizontalAlign.right;
          }
        }
        if (style.hAlign === ns.HorizontalAlign.center) {
          x += (w + tw) / 2;
        } else if (style.hAlign === ns.HorizontalAlign.right) {
            
          x += (w - tw/2) ;
        } else {
          x += tw;
        }
        if (style.vAlign === ns.VerticalAlign.center) {
          y += (h - th) / 2;
        } else if (style.vAlign === ns.VerticalAlign.bottom) {
          y += h - th - 2;
        }
        ctx.beginPath();
        ctx.translate(x, y);
        ctx.rotate(-0.5 * Math.PI);
        ctx.fillText(value, 0, 0);
        ctx.restore();
    }
    getAutoFitHeight(value, text, cellStyle, zoomFactor, context){
        return super.getAutoFitWidth.apply(this, arguments);
    }
    getAutoFitWidth(value, text, cellStyle, zoomFactor, context){
        return super.getAutoFitHeight.apply(this, arguments);
    }
}