﻿'use strict';

// defines functions that can be called from controllers and directives
angular.module('app').factory('templateSvc', function () {

    // save original control templates
    var tplInputNumber = wijmo.input.InputNumber.controlTemplate;
    var tplComboBox = wijmo.input.ComboBox.controlTemplate;
    var tplCalendar = wijmo.input.Calendar.controlTemplate;

    return {

        // get original control templates
        getTemplate: function (ctl) {
            switch (ctl) {
                case 'ComboBox':
                    return tplComboBox;
                case 'InputNumber':
                    return tplInputNumber;
                case 'Calendar':
                    return tplCalendar;
            }
        }
    }
});
