﻿using C1.Chart;
using C1.Win.Chart;
using C1.Win.Chart.Interaction;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FlexChartVisibleData
{
    public partial class Form1 : Form
    {
        private RangeSelector _rangeSelector;
        public Form1()
        {
            InitializeComponent();
            InitChart();
            InitRangeSelector();
            
        }

        private void InitChart()
        {
            _flexChart.Series.Clear();
            Random rnd = new Random();
            _flexChart.DataSource = Enumerable.Range(1, 50).Select(x => new Point(x, rnd.Next(10, 20))).ToList();
            _flexChart.BindingX = "X";
            _flexChart.ChartType = C1.Chart.ChartType.LineSymbols;
            _flexChart.Series.Add(new CustomSeries()
            {
                Binding = "Y"
            });
        }

        private void InitRangeSelector()
        {
            _flexChartRangeSelector.Series.Clear();
            _flexChartRangeSelector.DataSource = _flexChart.DataSource;
            _flexChartRangeSelector.BindingX = "X";
            _flexChartRangeSelector.ChartType = C1.Chart.ChartType.LineSymbols;
            _flexChartRangeSelector.Series.Add(new CustomSeries()
            {
                Binding = "Y"
            });
            _flexChartRangeSelector.Rendered += (s, e) =>
            {
                SetupRangeSelector();
            };
        }

        private void SetupRangeSelector()
        {
            if (_rangeSelector != null)
                return;
            _rangeSelector = new C1.Win.Chart.Interaction.RangeSelector(_flexChartRangeSelector);
            _rangeSelector.ValueChanged += (s, e) =>
            {
                _flexChart.AxisX.Min = _rangeSelector.LowerValue;
                _flexChart.AxisX.Max = _rangeSelector.UpperValue;
                _listBox.DataSource = null;
                _listBox.DataSource = (_flexChart.Series[0] as CustomSeries).VisibleItems;
            };
            _rangeSelector.LowerValue = _rangeSelector.UpperValue - 90;
        }
    }

    public class CustomSeries : Series
    {
        private List<object> _visibleItems;
        public IEnumerable<object> VisibleItems => _visibleItems;

        public CustomSeries()
        {
            _visibleItems = new List<object>();
            SymbolRendered += OnSymbolRendered;
        }

        private void OnSymbolRendered(object sender, RenderSymbolEventArgs e)
        {
            if(!_visibleItems.Contains(e.Item))
            {
                _visibleItems.Add(e.Item);
            }
        }

        protected override bool OnRendering(IRenderEngine engine)
        {
            _visibleItems.Clear();
            return base.OnRendering(engine);
        }
    }
}
