import { Component,Inject,ViewChild } from '@angular/core';
import { DataSvc}  from "./services/DataSvc";
import * as wjCore from "wijmo/wijmo";
import * as wjGrid from "wijmo/wijmo.grid";
import * as wjGridXlsx from "wijmo/wijmo.grid.xlsx";


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  
})
export class AppComponent {
  public data:wjCore.CollectionView;
  constructor(@Inject(DataSvc) _dataSvc : DataSvc){
    this.data= new wjCore.CollectionView(_dataSvc.getData(10));
  }
  @ViewChild("flex") flex: wjGrid.FlexGrid;
  exportExcel(){
    wjGridXlsx.FlexGridXlsxConverter.save(this.flex,{},"Flex.xlsx");
  }
}
