import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjSheet from 'wijmo/wijmo.grid.sheet';



@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
    title = 'FlexGrid';
    public data: wjCore.CollectionView;
    public country: any[];
    protected dataSvc: DataSvc;
    
    @ViewChild('flex') flex: wjGrid.FlexGrid;
    constructor( @Inject(DataSvc) dataSvc: DataSvc) {
        this.dataSvc = dataSvc;
        this.data = new wjCore.CollectionView(this.dataSvc.getData(20));
        this.country =this.dataSvc.getCountry();
    }
}
