

import * as wjcCore from 'wijmo/wijmo';



'use strict';

import { Injectable } from '@angular/core';
import { Observable } from "rxjs";

// Common data service
@Injectable()
export class DataSvc {


    getData(count: number): wjcCore.ObservableArray {
        var desc = 'International Business Machines Corp,Google Inc,Thomson Reuters,Microsoft Corp,Apple Inc,Random Text that happens to be long'.split(','),
            countries = 'US,Germany,UK,Japan,Italy,Greece'.split(','),
            data = new wjcCore.ObservableArray();
        for (var i = 0; i < count; i++) {
            data.push({
                id: i,
                country: countries[i % countries.length],
                "description with long header to test": desc[i % desc.length],
                date: new Date(2014, i % 12, i % 28),
                amount: Math.random() * 10000,
                active: i % 4 == 0,
                contact: '9876543210',
                country1: countries[i % countries.length],
                description1: desc[i % desc.length],
                date1: new Date(2014, i % 12, i % 28),
                amount1: Math.random() * 10000,
                active1: i % 4 == 0,
                contact1: '9876543210'
            });
        }
        return data;
    }

    getTreeData() {
        return [
            {
                name: '\u266B Adriane Simione', items: [
                    {
                        name: '\u266A Intelligible Sky', items: [
                            { name: 'Theories', length: '2:02' },
                            { name: 'Giant Eyes', length: '3:29' },
                            { name: 'Jovian Moons', length: '1:02' },
                            { name: 'Open Minds', length: '2:41' },
                            { name: 'Spacetronic Eyes', length: '3:41' }]
                    }
                ]
            },
            {
                name: '\u266B Amy Winehouse', items: [
                    {
                        name: '\u266A Back to Black', items: [
                            { name: 'Addicted', length: '1:34' },
                            { name: 'He Can Only Hold Her', length: '2:22' },
                            { name: 'Some Unholy War', length: '2:21' },
                            { name: 'Wake Up Alone', length: '3:43' },
                            { name: 'Tears Dry On Their Own', length: '1:25' }]
                    }]                

            }];
    }
    getCountry() {
        return 'US,Germany,UK,Japan,Italy,Greece'.split(',');
    }
}

