import { Component } from '@angular/core';
export var HelloWorldComponent = (function () {
    function HelloWorldComponent() {
        this.data = this.getData(100);
    }
    HelloWorldComponent.prototype.getData = function (count) {
        var countries = 'US,Germany,UK,Japan,Italy,Greece'.split(','), data = [];
        for (var i = 0; i < count; i++) {
            data.push({
                id: i,
                country: countries[i % countries.length],
                date: new Date(2014, i % 12, i % 28),
                amount: Math.round(Math.random() * 10000),
                active: i % 4 == 0
            });
        }
        return data;
    };
    HelloWorldComponent.decorators = [
        { type: Component, args: [{
                    selector: 'hello-world-app',
                    templateUrl: 'hello-world.template.html',
                    styleUrls: ['hello-world.style.css']
                },] },
    ];
    HelloWorldComponent.ctorParameters = [];
    return HelloWorldComponent;
}());
//# sourceMappingURL=hello-world.component.js.map