import { Component } from '@angular/core';

@Component({
  selector: 'hello-world-app',
  templateUrl: 'hello-world.template.html',
  styleUrls: ['hello-world.style.css']
})
export class HelloWorldComponent {
    data: any[];

    constructor() {
        this.data = this.getData(100);
    }

    getData(count: number): any[] {
        var countries = 'US,Germany,UK,Japan,Italy,Greece'.split(','),
            data = [];
        for (var i = 0; i < count; i++) {
            data.push({
                id: i,
                country: countries[i % countries.length],
                date: new Date(2014, i % 12, i % 28),
                amount: Math.round(Math.random() * 10000),
                active: i % 4 == 0
            });
        }
        return data;
    }

}
