﻿'use strict';

import { Injectable } from '@angular/core';
import { retry } from 'rxjs/operator/retry';

// Common data service
@Injectable()
export class DataSvc {

    // get data for grid
    public getData(count: number): any[] {
        var countries = 'US,Germany,UK,Japan,Italy,Greece'.split(','),
            data = [];
        for (let i = 0; i < count; i++) {
            data.push({
                id: i,
                country: countries[i % countries.length],
                date: new Date(2014, i % 12, i % 28),
                amount: Math.random() * 10000,
                active: i % 4 == 0
            });
        }
        return data;
    }
    getCountry() {
        return 'US,Germany,UK,Japan,Italy,Greece'.split(',');
    }
    getItemsSource() {
        var data = [
            { "id": 0, "country": {"name":'US' , 'continent':'America'}, "date": "2013-12-30T22:00:00.000Z", "amount": 2499.0972157351976, "active": true },
            { "id": 1, "country": { "name":'Germany', 'continent':'Europe'}, "date": "2014-01-31T22:00:00.000Z", "amount": 1986.8828015541994, "active": false },
            { "id": 2, "country": { "name": 'UK', 'continent': 'Europe' }, "date": "2014-03-01T22:00:00.000Z", "amount": 307.00672290479014, "active": false }
        ];
        return data;
    }
    getTreeData(){
        var items = [
            { header: 'Electronics',  items: [
                { header: 'Trimmers/Shavers' },
                { header: 'Tablets' },
                { header: 'Phones', items: [
                    { header: 'Apple' },
                    { header: 'Motorola' },
                    { header: 'Nokia' },
                    { header: 'Samsung' }
                ]
                },
                {header:'LapTop',items:[
                    {header:'Dell'},
                    {header:'Lenovo'}
                ]},
                { header: 'Speakers' },
                { header: 'Monitors' }
            ]},
            { header: 'Toys', img: 'resources/toys.png', items: [
                { header: 'Shopkins' },
                {header:'Train Sets'},
                {header:'Science Kit'},
                {header:'Play-Doh'},
                {header:'Crayola'},
                ]},
            { header: 'Home', img: 'resources/home.png'}
        ];
        return items;
    }
}
