import * as wjCore from 'wijmo/wijmo';
import * as wjInput from 'wijmo/wijmo.input';


import { Component, Inject, OnInit } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { Observable } from 'rxjs/Observable'
import { DataSvc } from './services/DataSvc';
import 'rxjs/Rx'; // includes all operators


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css'],
  //changeDetection: ChangeDetectionStrategy.Default
})
export class AppComponent implements OnInit {
  title = 'Wijmo Input Controls with Reactive Model driven forms';
  
  form: FormGroup;
  
  constructor(  public formBuilder: FormBuilder) {
        
  }
  
  ngOnInit() {
      
      this.form = this.formBuilder.group({
          vehicleHeight: [50],
          dueDate: [new Date()],
          contact:['U']
      });
      console.log(this.form)
  }


  submit() {
      let str = `Height ${this.form.value.vehicleHeight} \n Date ${this.form.value.dueDate} \n
Contact ${this.form.value.contact}`;
      alert(str);
     
  }
  
 
}
