﻿'use strict';

/**************************************************
    app
*/

var app = {};

// define all when page loads
onload = function () {




    var ngFmt2 = new wijmo.olap.PivotEngine({
        autoGenerateFields: false,
        itemsSource: getDataSet(30),
        showColumnTotals: wijmo.olap.ShowTotals.GrandTotals,
        showRowTotals: wijmo.olap.ShowTotals.GrandTotals,
        fields: [
            { binding: 'product', header: 'product' },
            { binding: 'country', header: 'country' },
            { binding: 'active', header: 'active' },
            { binding: 'discount', header: 'discount' }
        ]
    });
    ngFmt2.rowFields.push('product', 'country', 'active');
    ngFmt2.valueFields.push('discount');
    app.pivotGrid = new wijmo.olap.PivotGrid('#pivotGrid2', {
        itemsSource: ngFmt2,
        showSelectedHeaders: 'All'
    });
    
    app.pivotGrid.formatItem.addHandler(function (s, e) {
        var x = e;

        if (x.col == 1)
            x.cell.innerHTML = '<a href="https://www.w3schools.com">Visit W3Schools</a>';

    });



    $("#exportExcel").click(function () {
        // create book with current view
        var book = wijmo.grid.xlsx.FlexGridXlsxConverter.save(app.pivotGrid, {
            includeColumnHeaders: true,
            includeRowHeaders: true,
            formatItem: function(e) {
                if (e.col === 1) {
                    // get formatted cell content and retrieve a link info from it
                    var cell = e.getFormattedCell(),
                        link = getLink(cell);
                    if (link) {
                        // specify link caption
                        e.xlsxCell.value = link.caption;
                        // specify link URL
                        e.xlsxCell.link = link.href;
                        // Style text using styling of the custom cell content.
                        var font = e.xlsxCell.style.font;
                        font.bold = parseFloat(link.style.fontWeight) > 400;
                        font.color = link.style.color;
                        font.underline = link.style.textDecoration.indexOf('underline') > -1;
                    }
                }
            }
        });
        book.sheets[0].name = 'Main View';
        // save book
        book.save('wijmo.olap.xlsx');
    })

    $("#exportPdf").click(function () {
        wijmo.grid.pdf.FlexGridPdfConverter.export(app.pivotGrid, 'PivotGrid', {
            styles: {
                cellStyle: {
                    backgroundColor: '#ffffff',
                    borderColor: '#c6c6c6'
                },
                altCellStyle: {
                    backgroundColor: '#f9f9f9'
                },
                groupCellStyle: {
                    backgroundColor: '#dddddd'
                },
                headerCellStyle: {
                    backgroundColor: '#eaeaea'
                }
            },
            //customCellContent: true,
            formatItem: function (e) {
                if (e.col === 1) {
                    // get formatted cell content and retrieve a link info from it
                    var cell = e.getFormattedCell(),
                        link = getLink(cell);
                    if (link) {
                        var clRect = e.clientRect,
                            contRect = e.contentRect,
                            font = e.style.font.clone();
                        font.weight = link.style.fontWeight;
                        font.size = parseFloat(link.style.fontSize) / 96 * 72;
                        // Fill cell background with a default color - with custom drawing it doesn't happen automatically
                        e.canvas.paths.rect(clRect.left, clRect.top, clRect.width, clRect.height)
                            .fill(e.style.backgroundColor);
                        // Draw a link using text styling of the custom cell content. 
                        // The 'link' option makes this text a link.
                        e.canvas.drawText(link.caption, contRect.left, e.textTop, {
                            link: link.href, // <-- this makes text a link
                            font: font,
                            brush: link.style.color,
                            underline: link.style.textDecoration.indexOf('underline') > -1
                        });
                        // Cancel standard cell drawing; otherwise, it will overlap our custom drawing.
                        e.cancel = true;
                    }
                }
            }
        });
    })

    $("#movePrev").click(function () {
        app.pivotGrid2.collectionView.moveToPreviousPage();
    })


    $("#colRows").click(function () {
        app.pivotGrid2.collapseRowsToLevel(1);
    })


    function handleLoadedRows() {
        app.pivotGrid2.autoSizeColumns(0, app.pivotGrid2.columns.length, true, 22);
        app.pivotGrid2.autoSizeColumns(0, app.pivotGrid2.columns.length, false, 15);
        app.pivotGrid2.autoSizeRows(0, app.pivotGrid2.rows.length, true, 10);
        app.pivotGrid2.autoSizeRows(0, app.pivotGrid2.rows.length, false, 10);
   }

    // Retrieves and returns information about <a href> element contained in the specified element.
    // Returns null if <a> element is not found.
    function getLink(element) {
        var link = element && element.querySelector('a');
        if (link) {
            return { href: link.href, caption: link.textContent, style: window.getComputedStyle(link) };
        }

        return null;
    }














    //app.pivotGrid2.formatItem.addHandler(function (s, e) {
    //    var x = e;

    //    e.cell.innerHTML += ' <span style="font-size:120%" ></span>';
    //    x.cell.style.fontWeight = 'bold';
    //    var value = s.getCellData(x.row, x.col);


    //    if (x.col == 2 &&  x.row>1)
    //        x.cell.innerHTML = '<span>gdgdgdg/span> ';
    //    if (x.col == 3 && x.row > 1 )
    //        x.cell.innerHTML = '<span>dgdgdg</span> ';

    //    if (x.col == 4 && x.row > 1)
    //          x.cell.innerHTML = '<span>' + value + '</span> <img src="styles\\icons\\oicon-Green_UpArrow.png">';
    //    if (x.col == 5 && x.row > 1)
    //        x.cell.innerHTML = '<span>' + value + '</span> <img src="styles\\icons\\oicon-Yellow_DownArrow.png">';

    //    if (x.col == 2 && x.row > 1 && value != 'undefined' && value != null)
    //        x.cell.style.backgroundColor = "#ff0000";

    //});


}


/**************************************************
    utilities
*/

// save/load/transpose/export views
function transposeView(ng) {
    ng.deferUpdate(function () {

        // save row/col fields
        var rows = [],
            cols = [];
        for (var r = 0; r < ng.rowFields.length; r++) {
            rows.push(ng.rowFields[r].header);
        }
        for (var c = 0; c < ng.columnFields.length; c++) {
            cols.push(ng.columnFields[c].header);
        }

        // clear row/col fields
        ng.rowFields.clear();
        ng.columnFields.clear();

        // restore row/col fields in transposed order
        for (var r = 0; r < rows.length; r++) {
            ng.columnFields.push(rows[r]);
        }
        for (var c = 0; c < cols.length; c++) {
            ng.rowFields.push(cols[c]);
        }
    });
}

// build a title for the current view
function getViewTitle(ng) {
    var title = '';
    for (var i = 0; i < ng.valueFields.length; i++) {
        if (i > 0) title += ', ';
        title += ng.valueFields[i].header;
    }
    title += ' by ';
    if (ng.rowFields.length) {
        for (var i = 0; i < ng.rowFields.length; i++) {
            if (i > 0) title += ', ';
            title += ng.rowFields[i].header;
        }
    }
    if (ng.rowFields.length && ng.columnFields.length) {
        title += ' and by ';
    }
    if (ng.columnFields.length) {
        for (var i = 0; i < ng.columnFields.length; i++) {
            if (i > 0) title += ', ';
            title += ng.columnFields[i].header;
        }
    }
    return title;
}

// adds a title cell into an xlxs sheet
function addTitleCell(sheet, title) {

    // create cell
    var cell = new wijmo.xlsx.WorkbookCell();
    cell.value = title;
    cell.style = new wijmo.xlsx.WorkbookStyle();
    cell.style.font = new wijmo.xlsx.WorkbookFont();
    cell.style.font.bold = true;

    // create row to hold the cell
    var row = new wijmo.xlsx.WorkbookRow();
    row.cells[0] = cell;

    // and add the new row to the sheet
    sheet.rows.splice(0, 0, row);
}

// gets a random integer between zero and max
function randomInt(max) {
    return Math.floor(Math.random() * (max + 1));
}



    // gets a slightly more complex data set for more advanced demos
    function getDataSet(cnt) {
        var countries = 'USA,Germany,UK,Japan,Italy,Greece,Spain,Portugal'.split(','),
            products = 'Wijmo,Aobb bbbb,Xuni,Olap'.split(','),
            data = [];
        for (var i = 0; i < cnt; i++) {
            data.push({
                id: i,
                product: products[randomInt(products.length - 1)],
                country: countries[randomInt(countries.length - 1)],
                date: new Date(2015 + randomInt(2), randomInt(11), randomInt(27) + 1),
                sales: randomInt(10000),
                downloads: randomInt(10000),
                active: randomInt(1) ? true : false,
                discount: Math.random()
            });
        }
        return new wijmo.collections.CollectionView(data);
    }

