"use strict";
///<reference path="../typings/globals/core-js/index.d.ts"/>
var wjCore = require("wijmo/wijmo");
var Globalization = (function () {
    function Globalization() {
        this._culture = "en";
        this._loadCultureInfo();
    }
    Object.defineProperty(Globalization.prototype, "culture", {
        get: function () {
            return this._culture;
        },
        set: function (value) {
            if (this._culture != value) {
                this._culture = value;
                this._loadCultureInfo();
            }
        },
        enumerable: true,
        configurable: true
    });
    Globalization.prototype._loadCultureInfo = function () {
        var self = this;
        $.ajax({
            url: 'scripts/vendor/wijmo.culture.' + self.culture + '.js',
            dataType: 'script',
            success: function (data) {
                // culture applied, now load translations
                $.ajax({
                    url: 'translations/strings.' + self.culture + '.js',
                    dataType: 'json',
                    async: false,
                    success: function (data) {
                        console.log("Culture Load");
                        self.i18n = data;
                        // update controls to reflect changes
                        wjCore.Control.invalidateAll();
                    }
                });
            }
        });
    };
    return Globalization;
}());
exports.Globalization = Globalization;
//# sourceMappingURL=Globalization.js.map