﻿///<reference path="../typings/globals/core-js/index.d.ts"/>
import * as wjCore from "wijmo/wijmo";
export class Globalization {
    protected _culture: string;    
    i18n: any;
    constructor() {        
        this._culture = "en";
        this._loadCultureInfo();
    }
    get culture(): string {
        return this._culture;
    }
    set culture(value: string) {
        if (this._culture != value) {
            this._culture = value;
            this._loadCultureInfo();
        }
    }
    
    protected _loadCultureInfo() {       
        var self = this;            
            $.ajax({
            url: 'scripts/vendor/wijmo.culture.' + self.culture + '.js',
            dataType: 'script',
            success: function (data) {
                // culture applied, now load translations
                $.ajax({
                    url: 'translations/strings.' + self.culture + '.js',
                    dataType: 'json',
                    async: false,
                    success: function (data) {
                        console.log("Culture Load");
                        self.i18n = data;
                        // update controls to reflect changes
                        wjCore.Control.invalidateAll();
                    }
                });
            }        
        });        
    }
}