﻿///<reference path="../typings/globals/core-js/index.d.ts"/>
import { Component,AfterViewInit } from "@angular/core";
import { FormControl ,FormGroup,Validators,FormBuilder} from "@angular/forms";
import { Globalization } from './Globalization';
import { Router } from '@angular/router';
import * as wjCore from "wijmo/wijmo";
import * as wjInput from 'wijmo/wijmo.input';
@Component({
    selector: 'login',
    templateUrl: '../src/login.html'
})
export class Login extends Globalization  {
    public today: Date = new Date();
    public pi = 3.14;
    theTrue = true;
    myForm: FormGroup;
    public cultures=[
        {name:'English(US)',value:"en"},
        {name:'English(UK)',value:"en-GB"},
        {name:'Spanish',value:"es"},
        {name:'French',value:"fr"}
    ];
    constructor(private fb:FormBuilder) {
        super();
        let ftime = new Date(),
            minutes = Math.floor(ftime.getMinutes() / 15) * 15;
        ftime.setMinutes(minutes);
        //ftime.setSeconds(0);
        //ftime.setMilliseconds(0);

        this.myForm= this.fb.group({
            user:[''],
            ftime:[ftime],
            fdate:[new Date()],
            //lculture:['']
            lculture: ['en']
        });
    }   
    selectedIndexChanged(s: wjInput.ComboBox, e: wjCore.EventArgs) {
        console.log('selectedIndexChanged');
        console.log(this.myForm.value);          
        this.culture= this.myForm.value.lculture;
    }

}