Imports GrapeCity.ActiveReports 
Imports GrapeCity.ActiveReports.Document 

Public Class SectionReport1

    Private index As Integer
    Private details As ArrayList
    Private hidepageheader As Boolean = False

    Public Property ShowPageHeaderOnFirstPageOnly() As Boolean
        Get
            Return hidepageheader
        End Get
        Set(value As Boolean)
            hidepageheader = value
        End Set
    End Property

    Private Sub SectionReport1_DataInitialize(sender As System.Object, e As System.EventArgs) Handles MyBase.DataInitialize
        Me.Fields.Add("ProductName")
        Me.Fields.Add("UnitPrice")
        Me.Fields.Add("Quantity")

        ' Init some test data:
        Me.details = New ArrayList()
        Me.details.Add(New OrderDetail("A", 10.0, 2))
        Me.details.Add(New OrderDetail("B", 0.12, 1))
        Me.details.Add(New OrderDetail("D", 5.92, 3))
        Me.details.Add(New OrderDetail("E", 5.92, 3))
        Me.details.Add(New OrderDetail("F", 5.92, 3))
        Me.details.Add(New OrderDetail("G", 5.92, 3))
        Me.details.Add(New OrderDetail("H", 5.92, 3))
        Me.details.Add(New OrderDetail("I", 5.92, 3))
        Me.details.Add(New OrderDetail("J", 5.92, 3))
        Me.details.Add(New OrderDetail("K", 5.92, 3))
        Me.details.Add(New OrderDetail("L", 5.92, 3))
        Me.details.Add(New OrderDetail("M", 5.92, 3))
        Me.details.Add(New OrderDetail("N", 5.92, 3))
        Me.details.Add(New OrderDetail("O", 5.92, 3))
        Me.details.Add(New OrderDetail("P", 5.92, 3))
        Me.details.Add(New OrderDetail("Q", 5.92, 3))
        Me.details.Add(New OrderDetail("R", 5.92, 3))
        Me.details.Add(New OrderDetail("S", 5.92, 3))
        Me.details.Add(New OrderDetail("T", 5.92, 3))
        Me.details.Add(New OrderDetail("U", 5.92, 3))
        Me.details.Add(New OrderDetail("V", 5.92, 3))
        Me.details.Add(New OrderDetail("Q", 5.92, 3))
        Me.details.Add(New OrderDetail("X", 5.92, 3))
        Me.details.Add(New OrderDetail("Y", 5.92, 3))
        Me.details.Add(New OrderDetail("Z", 5.92, 3))
        Me.details.Add(New OrderDetail("AA", 5.92, 3))
        Me.details.Add(New OrderDetail("BA", 5.92, 3))
        Me.details.Add(New OrderDetail("CA", 5.92, 3))
        Me.details.Add(New OrderDetail("DA", 5.92, 3))
        Me.details.Add(New OrderDetail("EA", 5.92, 3))
        Me.details.Add(New OrderDetail("FA", 5.92, 3))
        Me.details.Add(New OrderDetail("GA", 5.92, 3))
        Me.index = -1
    End Sub

    Private Sub SectionReport1_FetchData(sender As System.Object, eArgs As GrapeCity.ActiveReports.SectionReport.FetchEventArgs) Handles MyBase.FetchData
        If Me.index >= Me.details.Count - 1 Then
            eArgs.EOF = True
            Return
        Else
            eArgs.EOF = False
        End If


        Dim row As OrderDetail = DirectCast(Me.details(System.Threading.Interlocked.Increment(Me.index)), OrderDetail)

        Me.Fields("ProductName").Value = row.productName
        Me.Fields("UnitPrice").Value = row.unitPrice
        Me.Fields("Quantity").Value = row.quantity
    End Sub

    Private Sub PageHeader_Format(sender As System.Object, e As System.EventArgs) Handles PageHeader.Format
        If hidepageheader = True Then
            If Me.PageNumber > 1 Then
                Me.PageHeader.Visible = False
            End If
        End If
    End Sub
End Class
