﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace PageNumber_MergedReports
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            SectionReport1 rpt = new SectionReport1();
            rpt.Run();
            SectionReport2 rpt2 = new SectionReport2();
            rpt2.Run();
            //Adding the pages of rpt2 to rpt
            rpt.Document.Pages.AddRange(rpt2.Document.Pages);
            //Using DrawText method to write the page number on the merged report 
            int i = 0;
            int totalpages = rpt.Document.Pages.Count;
            foreach (GrapeCity.ActiveReports.Document.Section.Page p in rpt.Document.Pages)
            {
                i += 1;
                string str;
                str = String.Format("Page {0} of " + totalpages.ToString(), i);
                SizeF size = new SizeF();
                Font tempfont = p.Font;
                Font ft = new Font("Arial", 9f);
                p.Font = ft;
                size = p.MeasureParagraphHeight(str, p.Width, p.Font, StringFormat.GenericTypographic);
                Single x;
                x = (p.Width - size.Width) / 2;
                Single y;
                y = (p.Height - p.Margins.Bottom);
                p.DrawText(str, x, y, size.Width, size.Height);
                p.Font = tempfont;
                ft = null;
                tempfont = null;
            }
            viewer1.Document = rpt.Document;
        }
    }
}
