﻿using System;
using System.IO;
using System.Xml;

namespace SharedDataSetReferenceUpdater
{
	class Program
	{
		static void Main(string[] args)
		{
			Console.WriteLine("Please enter full path to the directory with reports or enter nothing to update reports in current directory. 'q' to exit");

			string path;
			while ((path = Console.ReadLine()) != "q")
			{
				if (path == string.Empty)
					path = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);

				if (Directory.Exists(path))
				{
					try
					{
						var reportFiles = Directory.GetFiles(path, "*.rdlx", SearchOption.AllDirectories);
						foreach (var reportFile in reportFiles)
						{
							UpdateReport(reportFile);
						}
						Console.WriteLine("Update is fimished");

					}
					catch (Exception e)
					{
						Console.WriteLine(e.Message);
					}
				}
				else
					Console.WriteLine("There is no such directory");
			}
		}

		private static void UpdateReport(string path)
		{
			try
			{
				var reportXml = new XmlDocument();
				reportXml.Load(path);
				Console.WriteLine("Updating " + Path.GetFileName(path));
				var newReportXml = SharedDataSetReferenceUpdater.UpdateSharedResourceReferences(reportXml);
				if (newReportXml != null)
				{
					Console.WriteLine("Writing " + Path.GetFileName(path));
					newReportXml.Save(path);
				}
			}
			catch (Exception e)
			{
				Console.WriteLine(e.Message);
			}
		}
	}
}
