﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Data.Services.Client;
using CrimeStats.CityCrimeService;

namespace CrimeStats
{
    public partial class MainPage : PhoneApplicationPage
    {
        private datagovCrimesContainer _context;
        private readonly Uri _crimesUri = new Uri("https://api.datamarket.azure.com/data.gov/Crimes/");
        private DataServiceCollection<CityCrime> _crimes;

        String _userId = "richd@componentone.com";
        const String _key = "FtsDefZvJNf0MXiTgFgxmiqGqYKkK6kkNrC3xiPCEdU=";

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            _context = new datagovCrimesContainer(_crimesUri);
            _crimes = new DataServiceCollection<CityCrime>(_context);
            var _query = from c in _context.CityCrime where c.State == "Pennsylvania" && c.City == "Pittsburgh" orderby c.Year select c;

            _context.Credentials = new NetworkCredential(_userId, _key);

            // Register for the LoadCompleted event.
            _crimes.LoadCompleted
                += new EventHandler<LoadCompletedEventArgs>(crimes_LoadCompleted);

            // Load the customers feed by executing the LINQ query.
            _crimes.LoadAsync(_query);
        }

        void crimes_LoadCompleted(object sender, LoadCompletedEventArgs e)
        {
            this.LayoutRoot.DataContext = _crimes;
        }
    }
}