﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data.Services.Client;
using System.Linq;
using System.Net;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using Infochimps;

namespace FixedQueryCS
{
	public partial class MainPage : PhoneApplicationPage
	{
		private const string _serviceRootUrl = "https://api.datamarket.azure.com/InfoChimpsInc/Trstrank/";
		private const string _email = "bugs@acme.com";
		private const string _key = "PutYourKeyHere";

		private Uri _serviceUri;
		private TrstrankContainer _container;
		private ObservableCollection<TrstrankEntity> _tweeterCollection;

		// Constructor
		public MainPage()
		{
			InitializeComponent();

			_serviceUri = new Uri(_serviceRootUrl);
			_container = new TrstrankContainer(_serviceUri);
			_container.Credentials = new NetworkCredential(_email, _key);

			_container.SendingRequest += new EventHandler<SendingRequestEventArgs>(InjectBasicAuthenticationHeader);

			var _query = _container.GetTrstrankUsingScreenName("rj_dudley");

			((DataServiceQuery<TrstrankEntity>)_query).BeginExecute(OnTrstRankQueryComplete, _query);

		}

		void InjectBasicAuthenticationHeader(object sender, SendingRequestEventArgs e)
		{
			// BASIC authentication is just a bas64 encoded value sent in clear text, quite unsafe without HTTPS encryption
			byte[] basicAuthenticationHeaderInBytes =
					Encoding.UTF8.GetBytes(String.Format("{0}:{1}", _email, _key));
			string basicAuthenticationHeader = Convert.ToBase64String(basicAuthenticationHeaderInBytes);
			// the NTLM header for Basic auth follows this format -> Authorization: Basic <base64encodedcredentials>
			e.RequestHeaders[HttpRequestHeader.Authorization] = String.Format("Basic {0}", basicAuthenticationHeader);
		}


		public void OnTrstRankQueryComplete(IAsyncResult result)
		{
			Dispatcher.BeginInvoke(() =>
			{
				IEnumerable<TrstrankEntity> response = null;

				var query = result.AsyncState as DataServiceQuery<TrstrankEntity>;
				response = query.EndExecute(result);

				TrstrankEntity _tweeter = response.ElementAt(0);


				TrustRank.Text = _tweeter.TrstrankReputationMeasure.ToString();

			});
		}  // end OnRateSummaryQueryComplete


	}
}