﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using C1.Win.C1Gauge;
using System.Xml;

namespace GaugeInC1RibbonDemo
{
    public class GaugeHostControl : C1.Win.C1Ribbon.RibbonControlHost
    {
        private C1LinearGauge linearGauge;

        public GaugeHostControl()
            : base(new C1.Win.C1Gauge.C1Gauge())
        {
            linearGauge = new C1LinearGauge();
            XmlDocument doc = new XmlDocument();
            doc.LoadXml(Properties.Resources.Ruler);
            linearGauge.Load(doc);
            
            C1Gauge.Gauges.Add(linearGauge);
            C1Gauge.BackColor = System.Drawing.Color.Azure;
            linearGauge.PointerDragMove += LinearGauge_PointerDragMove;
        }

        [Browsable(false)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public C1.Win.C1Gauge.C1Gauge C1Gauge
        {
            get { return (C1.Win.C1Gauge.C1Gauge)Control; }
        }
        private void LinearGauge_PointerDragMove(System.Object sender, PointerDragEventArgs e)
        {
            e.Pointer.UpdateValue(e.NewValue, 0.5);
        }

    }

}
