﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Win_Flex_ScrollbarCustomContextMenu
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            myFlexGrid1.DataSource = GetTable();
        }

        static DataTable GetTable()
        {
            DataTable table = new DataTable();
            table.Columns.Add("Dosage", typeof(int));
            table.Columns.Add("Drug", typeof(string));
            table.Columns.Add("Patient", typeof(string));
            table.Columns.Add("Date", typeof(DateTime));

            table.Rows.Add(25, "Indocin", "David", DateTime.Now);
            table.Rows.Add(50, "Enebrel", "Sam", DateTime.Now);
            table.Rows.Add(10, "Hydralazine", "Christoff", DateTime.Now);
            table.Rows.Add(21, "Combivent", "Janet", DateTime.Now);
            table.Rows.Add(100, "Dilantin", "Melanie", DateTime.Now);
            table.Rows.Add(100, "John", "Smith", DateTime.Now);
            table.Rows.Add(100, "Andrew", "Parker", DateTime.Now);
            table.Rows.Add(100, "James", "Johnson", DateTime.Now);
            table.Rows.Add(100, "Dilantin", "Melanie", DateTime.Now);
            table.Rows.Add(100, "Robert", "Gilbert", DateTime.Now);
            table.Rows.Add(100, "Dilantin", "Thompson", DateTime.Now);
            table.Rows.Add(100, "Dave", "Richardson", DateTime.Now);
            return table;
        }
    }

    public class MyFlexGrid : C1.Win.C1FlexGrid.C1FlexGrid
    {
        private static readonly int WM_CONTEXTMENU = 123;
        protected override void WndProc(ref Message m)
        {
            if (m.Msg == WM_CONTEXTMENU)
            {
                //using Custom Context Menu 
                if (this.HitTest().Row == -1 && this.HitTest().Column == -1)
                {
                    ContextMenu st = CreateMenu();
                    Point menuLocation = new Point(ScrollBar.MousePosition.X, ScrollBar.MousePosition.Y);
                    st.Show(this, this.PointToClient(menuLocation));
                }
                else
                    base.WndProc(ref m);
            }
            else
            {
                base.WndProc(ref m);
                this.ContextMenuStrip = null;
            }
        }

        public ContextMenu CreateMenu()
        {
            MenuItem[] mi = new MenuItem[3];
            mi[0] = new MenuItem("Item1", MenuItem_Click);
            mi[1] = new MenuItem("Item2", MenuItem_Click);
            mi[2] = new MenuItem("Item3", MenuItem_Click);
            ContextMenu cm = new ContextMenu(mi);
            return cm;
        }

        void MenuItem_Click(object sender, EventArgs e)
        {
            MenuItem mi = sender as MenuItem;
            if (mi != null)
            {
                MessageBox.Show(mi.Text);
            }
        }
    }
}
