﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Browser;
using C1.Silverlight;
using System.Windows.Printing;
using C1.Silverlight.PdfViewer;
using System.IO;
using System.Windows.Markup;
using System.Windows.Controls.Primitives;

namespace PdfViewerSamples
{
    public partial class MainPage : UserControl
    {
  
        public MainPage()
        {
            InitializeComponent();
            var resource = Application.GetResourceStream(new Uri("/PdfViewerSamples;component/C1XapOptimizer.pdf", UriKind.Relative));
           
            pdfViewer.LoadDocument(resource.Stream);
        
        }

        void RotateLeft(object sender, RoutedEventArgs args)
        {
            pdfViewer.PageTemplate = ApplyRotateStyle(-90); 
            pdfViewer.HorizontalScrollBar.Visibility    = Visibility.Visible  ;    
            pdfViewer.HorizontalScrollBar.ViewportSize = pdfViewer.ViewportHeight;
        }

        void RotateRight(object sender, RoutedEventArgs args)
        {
            pdfViewer.PageTemplate = ApplyRotateStyle(90);
            pdfViewer.HorizontalScrollBar.Visibility = Visibility.Visible;
            pdfViewer.HorizontalScrollBar.ViewportSize = pdfViewer.ViewportHeight;
            
        }

        public DataTemplate ApplyRotateStyle(double angle)
        {
            string str=@"<DataTemplate  xmlns=""http://schemas.microsoft.com/winfx/2006/xaml/presentation""
    xmlns:x=""http://schemas.microsoft.com/winfx/2006/xaml""
      
    xmlns:c1=""http://schemas.componentone.com/winfx/2006/xaml"">
                          <c1:C1LayoutTransformer>
                            <c1:C1LayoutTransformer.LayoutTransform>
                                <RotateTransform Angle="""+angle+ @""" />
                            </c1:C1LayoutTransformer.LayoutTransform>
                            <Grid Margin=""{Binding Source.PageSeparation}"" Cursor=""IBeam"">
                                <Grid.Resources>
                                    <c1:ZoomToScaleTransformConverter x:Key=""zoomConverter""/>
                                </Grid.Resources>
                                <Border Background=""#19000000"" Margin=""4,4,-4,-4"" CornerRadius=""2"" />
                                <Border Background=""#19000000"" Margin=""3,3,-3,-3"" CornerRadius=""2""/>
                                <Border Background=""#19000000"" Margin=""2,2,-2,-2"" CornerRadius=""2"" />
                                <Border Background=""#19000000"" Margin=""1,1,-1,-1"" CornerRadius=""2"" />
                                <Border Background=""White""/>
                           
                                <c1:C1LayoutTransformer LayoutTransform=""{Binding Source.Zoom, Converter={StaticResource zoomConverter}}""
                                                CacheMode=""{Binding Source.CacheMode}"">
                                    <ContentPresenter Content=""{Binding Content}""/>
                                </c1:C1LayoutTransformer>
                           
                                <Border BorderThickness=""1"" BorderBrush=""#FF858585""/>
                            </Grid>
                        </c1:C1LayoutTransformer>
                    </DataTemplate>";
     
           return  (DataTemplate)XamlReader.Load(str);
             
        }
    }

    public class MyPdfViewer : C1.Silverlight.PdfViewer.C1PdfViewer
    {
        private ScrollBar _vsb;
        private ScrollBar _hsb;

        public ScrollBar VerticalScrollBar { get { return _vsb; } }
        public ScrollBar HorizontalScrollBar { get { return _hsb; } }

        public override void OnApplyTemplate()
        {
            base.OnApplyTemplate();
           _hsb= GetTemplateChild("HorizontalScrollBar") as ScrollBar ;
           _vsb = GetTemplateChild("VerticalScrollBar") as ScrollBar;
        }

    }


   

}
