﻿Imports System.Drawing.Imaging

Public Class Form1

    Dim enabledImage As Bitmap
    Dim disabledImage As Bitmap

    Public Sub New()
        InitializeComponent()
        GenerateImages()
    End Sub

    'Create two image objects 
    Private Sub GenerateImages()
        enabledImage = New Bitmap(c1PictureBox2.Image)
        disabledImage = New Bitmap(enabledImage.Width, enabledImage.Height)

        Using G As Graphics = Graphics.FromImage(disabledImage)
            Using IA As New ImageAttributes()
                Dim CM As New ColorMatrix()
                CM.Matrix33 = 0.5F
                IA.SetColorMatrix(CM)
                Dim R As New Rectangle(0, 0, enabledImage.Width, enabledImage.Height)
                G.DrawImage(enabledImage, R, R.X, R.Y, R.Width, R.Height, _
                 GraphicsUnit.Pixel, IA)
            End Using
        End Using
    End Sub

    'First Approach - using Paint event
    Private Sub c1PictureBox1_Paint(sender As System.Object, e As System.Windows.Forms.PaintEventArgs) Handles c1PictureBox1.Paint
        If Not c1PictureBox1.Enabled Then
            Using fBrush As Brush = New SolidBrush(Color.FromArgb(171, 71, 71, 71))
                e.Graphics.FillRectangle(fBrush, Me.c1PictureBox1.ClientRectangle)
            End Using
        End If
    End Sub

    'Second Approach - using two Image objects  
    Private Sub c1PictureBox2_EnabledChanged(sender As System.Object, e As System.EventArgs) Handles c1PictureBox2.EnabledChanged
        c1PictureBox2.Image = If(c1PictureBox2.Enabled, enabledImage, disabledImage)
    End Sub

    'Toggle Enabled Property of the C1PictureBox objects
    Private Sub c1CheckBox1_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles c1CheckBox1.CheckedChanged
        c1PictureBox1.Enabled = c1CheckBox1.Checked
        c1PictureBox2.Enabled = c1CheckBox1.Checked
    End Sub

    
End Class
