﻿Imports C1.Silverlight.Data

Partial Public Class MainPage
    Inherits UserControl

    Public Sub New()
        InitializeComponent()

        c1FlexGrid1.AutoGenerateColumns = False

        Dim column As New C1.Silverlight.FlexGrid.Column
        column.Header = "List Names"
        c1FlexGrid1.Columns.Add(column)

        BindGrid()
        c1FlexGrid1.CellFactory = New MyCellFactory()

    End Sub


    Private Sub BindGrid()

        Dim _mainDataList As New List(Of mainDataClassCollection)

        For i As Integer = 0 To 5
            _mainDataList.Add(New mainDataClassCollection(i))
        Next

        Dim bnd As New System.Windows.Data.Binding
        bnd.Path = New PropertyPath("ListData")
        bnd.Mode = Data.BindingMode.TwoWay
        bnd.UpdateSourceTrigger = Data.UpdateSourceTrigger.Default
        c1FlexGrid1.Columns(0).Binding = bnd

        c1FlexGrid1.ItemsSource = _mainDataList

        c1FlexGrid1.AutoSizeColumns(0, 0, 0)
        c1FlexGrid1.AutoSizeRows(0, c1FlexGrid1.Rows.Count - 1, 0)

    End Sub
End Class

Public Class MyCellFactory
    Inherits C1.Silverlight.FlexGrid.CellFactory

    Public Overrides Sub CreateCellContent(grid As C1.Silverlight.FlexGrid.C1FlexGrid, bdr As System.Windows.Controls.Border, rng As C1.Silverlight.FlexGrid.CellRange)
        MyBase.CreateCellContent(grid, bdr, rng)

        Dim chFlx As New C1.Silverlight.FlexGrid.C1FlexGrid
        chFlx.ItemsSource = CType(grid.Rows(rng.Row).DataItem, mainDataClassCollection).ListData
        chFlx.HeadersVisibility = C1.Silverlight.FlexGrid.HeadersVisibility.None
        grid.Rows(rng.Row).Height = 72
        chFlx.AutoSizeRows(0, chFlx.Rows.Count - 1, 0)
        chFlx.AutoSizeColumns(0, 0, 0)
        bdr.Child = chFlx
    End Sub
    
End Class

Public Class mainDataClassCollection

    Dim _list As List(Of myDataClass)

    Public Sub New(ByVal index As Integer)

        _list = New List(Of myDataClass)
        For i As Integer = 0 To 2
            _list.Add(New myDataClass("Name " + index.ToString() + i.ToString()))
        Next

    End Sub

    Public ReadOnly Property ListData() As List(Of myDataClass)
        Get
            Return _list
        End Get
    End Property

End Class

Public Class myDataClass

    Dim _name As String

    Public Sub New(ByVal _nm As String)
        _name = _nm
    End Sub

    Public Property Name() As String
        Get
            Return _name
        End Get
        Set(value As String)
            _name = value
        End Set

    End Property

End Class
