﻿Public Class UserControl1


    Dim ivisible As Integer = 0
    Dim col_sorted As String = ""
    Dim col_filtered As String = ""
    Dim count_sort As Integer = 0
    Dim count_filter As Integer = 0

    Private Sub UserControl1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Me.EmployeesTableAdapter.Fill(Me.C1NWindDataSet.Employees)
        C1FlexGrid1.SelectionMode = C1.Win.C1FlexGrid.SelectionModeEnum.ListBox
        C1FlexGrid1.AllowSorting = C1.Win.C1FlexGrid.AllowSortingEnum.MultiColumn
    End Sub

    Private Sub C1FlexGrid1_AfterFilter(ByVal sender As Object, ByVal e As System.EventArgs) Handles C1FlexGrid1.AfterFilter

        Name_FilteredCol.Text = ""
        Filtering_Type.Text = "NA"
        count_filter = 0
        ivisible = 0

        With C1FlexGrid1
            For i = 1 To .Rows.Count - 1 ' Beginning from 1 (0 is Header)
                If .Rows(i).IsVisible Then
                    ivisible += 1
                End If
            Next
        End With

        With C1FlexGrid1
            For i = 1 To .Cols.Count - 1
                If .Cols(i).Filter.IsActive Then
                    count_filter += 1
                    If count_filter > 1 Then
                        Name_FilteredCol.Text += ", "
                    End If
                    Name_FilteredCol.Text += C1FlexGrid1.Cols(i).Name
                End If
            Next
        End With

        If count_filter = 0 Then
            Filtering_Type.Text = "NA"
            Name_FilteredCol.Text = "NA"
            C1SplitterPanel1.Text = "Filtering : NA"
            Number_FilteredCol.Text = "NA"
        ElseIf count_filter = 1 Then
            Filtering_Type.Text = "Single Column"
            C1SplitterPanel1.Text = "Filtering : Applied"
            Number_FilteredCol.Text = count_filter.ToString
        ElseIf count_filter > 1 Then
            Filtering_Type.Text = "Multi Column"
            C1SplitterPanel1.Text = "Filtering : Applied"
            Number_FilteredCol.Text = count_filter.ToString
        End If

        Count_TotalRows.Text = (C1FlexGrid1.Rows.Count - 1).ToString
        Count_FilteredRows.Text = ivisible.ToString

    End Sub

    Private Sub C1FlexGrid1_AfterSelChange(ByVal sender As Object, ByVal e As C1.Win.C1FlexGrid.RangeEventArgs) Handles C1FlexGrid1.AfterSelChange
        e.Cancel = True
        CellIndex_Actual.Text = "Cell(" & e.NewRange.r1.ToString & "," & e.NewRange.c1.ToString & ")"
        ivisible = 0
        With C1FlexGrid1
            For i = 1 To .Rows.Count - 1 ' Beginning from 1 (0 is Header)
                If .Rows(i).IsVisible Then
                    ivisible += 1
                    If .Rows(i).Selected = True Then
                        CellIndex_Visible.Text = "Cell(" & ivisible.ToString & "," & C1FlexGrid1.ColSel.ToString & ")"
                    End If
                End If
            Next
        End With
    End Sub

    Private Sub C1FlexGrid1_AfterSort(ByVal sender As Object, ByVal e As C1.Win.C1FlexGrid.SortColEventArgs) Handles C1FlexGrid1.AfterSort
        count_sort = 0
        Name_SortedCol.Text = ""
        SortOrder_Col.Text = ""
        With C1FlexGrid1
            For i = 1 To .Cols.Count - 1 ' Beginning from 1 (0 is Header)
                If .Cols(i).Sort = C1.Win.C1FlexGrid.SortFlags.Ascending Then
                    count_sort += 1
                    If count_sort > 1 Then
                        Name_SortedCol.Text += ", "
                        SortOrder_Col.Text += ","
                    End If
                    Name_SortedCol.Text += C1FlexGrid1.Cols(i).Name
                    SortOrder_Col.Text += "Ascending"
                ElseIf C1FlexGrid1.Cols(i).Sort = C1.Win.C1FlexGrid.SortFlags.Descending Then
                    count_sort += 1
                    If count_sort > 1 Then
                        Name_SortedCol.Text += ", "
                        SortOrder_Col.Text += ","
                    End If
                    Name_SortedCol.Text += C1FlexGrid1.Cols(i).Name
                    SortOrder_Col.Text += "Descending"
                End If
            Next
        End With

        If count_sort = 0 Then
            Sorting_Type.Text = ""
        ElseIf count_sort = 1 Then
            Sorting_Type.Text = "Single Column"
        ElseIf count_sort > 1 Then
            Sorting_Type.Text = "Multi Column"
        End If

        Numbr_SortedCol.Text = count_sort.ToString

        If count_sort > 0 Then
            C1SplitterPanel2.Text = "Sorting : Applied"
        Else
            C1SplitterPanel2.Text = "Sorting : NA"
        End If
    End Sub
End Class
